/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.AuthenticationSystemException;
import com.atlassian.bitbucket.auth.CaptchaAuthenticationException;
import com.atlassian.bitbucket.auth.CaptchaRequiredAuthenticationException;
import com.atlassian.bitbucket.auth.IncorrectCaptchaAuthenticationException;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.CaptchaResponse;
import com.atlassian.bitbucket.user.CaptchaService;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.CaptchaTicket;
import com.atlassian.stash.internal.user.InternalCaptchaService;
import com.google.common.base.Preconditions;
import com.octo.captcha.service.CaptchaServiceException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="captchaService")
@AvailableToPlugins(value=CaptchaService.class)
public class DefaultCaptchaService
extends AbstractService
implements InternalCaptchaService {
    public static final String FAILED_AUTHENTICATION_ATTEMPT_COUNT = "failedAuthenticationAttemptCount";
    private static final Logger log = LoggerFactory.getLogger(DefaultCaptchaService.class);
    private final com.octo.captcha.service.CaptchaService captchaService;
    private final CrowdControl crowdControl;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultCaptchaService(com.octo.captcha.service.CaptchaService captchaService, CrowdControl crowdControl, FeatureManager featureManager, I18nService i18nService, ApplicationPropertiesService propertiesService) {
        this.captchaService = captchaService;
        this.crowdControl = crowdControl;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
    }

    @Transactional(propagation=Propagation.SUPPORTS, noRollbackFor={AuthenticationException.class, NoSuchUserException.class})
    @Unsecured(value="This needs to be available during authentication")
    public AuthenticationResult authenticateWithCaptcha(@Nonnull CaptchaTicket captchaTicket, @Nonnull UncheckedOperation<AuthenticationResult> authenticateOperation) {
        Objects.requireNonNull(captchaTicket, "captchaTicket");
        Objects.requireNonNull(authenticateOperation, "authenticateOperation");
        Preconditions.checkArgument((boolean)(captchaTicket instanceof ValidCaptchaTicket), (Object)"invalid CaptchaTicket!");
        ValidCaptchaTicket validCaptchaTicket = (ValidCaptchaTicket)captchaTicket;
        try {
            AuthenticationResult result = (AuthenticationResult)authenticateOperation.perform();
            if (result != null) {
                validCaptchaTicket.onAuthenticationSuccess();
            }
            return result;
        }
        catch (IncorrectPasswordAuthenticationException e) {
            validCaptchaTicket.onAuthenticationFailure((AuthenticationException)((Object)e));
            throw e;
        }
    }

    @Nonnull
    @Transactional(noRollbackFor={CaptchaAuthenticationException.class})
    @Unsecured(value="This needs to be available during authentication")
    public CaptchaTicket checkCaptcha(@Nonnull String username, @Nullable CaptchaResponse captchaResponse) {
        Objects.requireNonNull(username, "username");
        UserWithAttributes attributes = this.crowdControl.findUserWithAttributes(username);
        if (this.isCaptchaRequired(attributes)) {
            if (captchaResponse == null) {
                log.debug("{}: A CAPTCHA is required, but no response was provided", (Object)username);
                throw new CaptchaRequiredAuthenticationException(this.missingCaptchaResponse());
            }
            if (!this.isCaptchaValid(captchaResponse)) {
                this.incrementAttemptCountFor(attributes);
                throw new IncorrectCaptchaAuthenticationException(this.invalidCaptcha());
            }
        }
        return new ValidCaptchaTicket(attributes);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#username, 'SYS_ADMIN'))")
    public void clear(@Nonnull String username) {
        User user = this.crowdControl.findUser(username, false);
        if (user == null) {
            throw this.newNoSuchUserException(username);
        }
        this.crowdControl.setUserAttribute(user, FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)0L);
        log.debug("{}: Failed authentication attempts cleared", (Object)user.getName());
    }

    @Transactional
    @Unsecured(value="This needs to be available during authentication")
    public void incrementFailedAuthenticationAttemptCount(@Nonnull String username) {
        UserWithAttributes user = this.crowdControl.findUserWithAttributes(username);
        if (user == null) {
            throw this.newNoSuchUserException(username);
        }
        this.incrementAttemptCountFor(user);
    }

    @Unsecured(value="This is essentially identical to checkCaptcha which is also unsecured")
    public boolean isRequired(@Nonnull String username) {
        UserWithAttributes user = this.crowdControl.findUserWithAttributes(username);
        if (user == null) {
            throw this.newNoSuchUserException(username);
        }
        return this.isCaptchaRequired(user);
    }

    @Unsecured(value="This needs to be available during signup")
    public boolean validate(@Nonnull CaptchaResponse captchaResponse) {
        return this.captchaService.validateResponseForID(captchaResponse.getChallengeId(), (Object)captchaResponse.getChallengeResponse());
    }

    private static long incrementAttemptCount(long val) {
        return val == Long.MAX_VALUE ? Long.MAX_VALUE : val + 1L;
    }

    private KeyedMessage captchaServiceFail() {
        return this.i18nService.createKeyedMessage("bitbucket.service.user.captchasvcfail", new Object[0]);
    }

    private long getAttemptCountFor(UserWithAttributes user) {
        String count;
        if (user != null && (count = user.getValue(FAILED_AUTHENTICATION_ATTEMPT_COUNT)) != null) {
            try {
                return Long.parseLong(count);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid attribute {} for user {}: {}", new Object[]{FAILED_AUTHENTICATION_ATTEMPT_COUNT, user.getName(), count});
            }
        }
        return 0L;
    }

    private void incrementAttemptCountFor(UserWithAttributes user) {
        if (user != null) {
            long initialCount = this.getAttemptCountFor(user);
            long newCount = DefaultCaptchaService.incrementAttemptCount(initialCount);
            this.crowdControl.setUserAttribute((User)user, FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)newCount);
            log.debug("{}: Updated failed attempts from {} to {} after incorrect CAPTCHA challenge", new Object[]{user.getName(), initialCount, newCount});
        }
    }

    private KeyedMessage invalidCaptcha() {
        return this.i18nService.createKeyedMessage("bitbucket.service.user.invalidcaptcha", new Object[0]);
    }

    private boolean isCaptchaRequired(UserWithAttributes user) {
        return this.isCaptchaRequired(this.getAttemptCountFor(user));
    }

    private boolean isCaptchaRequired(long attempts) {
        return this.propertiesService.getMode() != ApplicationMode.MIRROR && this.featureManager.isEnabled((Feature)StandardFeature.AUTH_CAPTCHA) && attempts > 0L && attempts >= (long)this.propertiesService.getMaxCaptchaAttempts();
    }

    private boolean isCaptchaValid(CaptchaResponse response) {
        try {
            return this.captchaService.validateResponseForID(response.getChallengeId(), (Object)response.getChallengeResponse());
        }
        catch (CaptchaServiceException e) {
            throw new AuthenticationSystemException(this.captchaServiceFail(), (Throwable)e);
        }
    }

    private KeyedMessage missingCaptchaResponse() {
        return this.i18nService.createKeyedMessage("bitbucket.service.user.missingcaptcharesponse", new Object[0]);
    }

    private NoSuchUserException newNoSuchUserException(String username) {
        throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.service.users.noSuchUser", new Object[]{username}), username);
    }

    private class ValidCaptchaTicket
    implements CaptchaTicket {
        private final UserWithAttributes user;
        private long attempts;

        private ValidCaptchaTicket(UserWithAttributes user) {
            this.attempts = DefaultCaptchaService.this.getAttemptCountFor(user);
            this.user = user;
        }

        public void onAuthenticationFailure(AuthenticationException exception) {
            if (this.user == null) {
                log.debug("<>: Ignoring failed authentication attempt");
            } else {
                long oldCount = this.attempts;
                this.attempts = DefaultCaptchaService.incrementAttemptCount(this.attempts);
                this.updateFailedAuthAttempts(this.attempts);
                if (DefaultCaptchaService.this.isCaptchaRequired(this.attempts)) {
                    log.debug("{}: Updated failed authentication attempts from {} to {}. A CAPTCHA is required", new Object[]{this.user.getName(), oldCount, this.attempts});
                    throw new CaptchaRequiredAuthenticationException(exception.getKeyedMessage());
                }
                log.debug("{}: Updated failed authentication attempts from {} to {}", new Object[]{this.user.getName(), oldCount, this.attempts});
            }
        }

        public void onAuthenticationSuccess() {
            if (this.attempts != 0L) {
                this.updateFailedAuthAttempts(0L);
                log.debug("{}: Cleared {} failed authentication attempts after successful challenge", (Object)this.user.getName(), (Object)this.attempts);
            }
        }

        private void updateFailedAuthAttempts(long newCount) {
            DefaultCaptchaService.this.crowdControl.setUserAttribute((User)this.user, DefaultCaptchaService.FAILED_AUTHENTICATION_ATTEMPT_COUNT, (Object)newCount);
        }
    }
}

