/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.stash.internal.auth.RedirectHelper;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import jakarta.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
public class DefaultRedirectHelper
implements RedirectHelper {
    private final FeatureManager featureManager;
    private final InternalUserSettingsService userSettingsService;

    public DefaultRedirectHelper(@Nonnull InternalUserSettingsService userSettingsService, @Nonnull FeatureManager featureManager) {
        this.userSettingsService = userSettingsService;
        this.featureManager = featureManager;
    }

    public boolean shouldShowGettingStartedPage(@Nonnull ApplicationUser user) {
        UserSettings userSettings = this.userSettingsService.getUserSettings(user);
        return this.featureManager.isEnabled((Feature)StandardFeature.GETTING_STARTED) && (Boolean)userSettings.getBoolean("SHOW_GETTING_STARTED_PAGE").getOrElse((Object)false) != false;
    }

    public boolean shouldShowGettingStartedPage(@Nonnull AuthenticationContext authenticationContext) {
        return authenticationContext.isAuthenticated() && authenticationContext.getCurrentUser() != null && this.shouldShowGettingStartedPage(authenticationContext.getCurrentUser());
    }
}

