/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.event.api.EventListener;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scopesRequestCacheDelegate")
@AvailableToPlugins(value=ScopesRequestCacheDelegate.class)
public class DefaultScopesRequestCacheDelegate
implements ScopesRequestCacheDelegate {
    private final OsgiContainerManager osgiContainerManager;
    private ServiceTracker<ScopesRequestCache, ScopesRequestCache> serviceTracker;

    @Autowired
    public DefaultScopesRequestCacheDelegate(OsgiContainerManager osgiContainerManager) {
        this.osgiContainerManager = osgiContainerManager;
    }

    public void clearRequestCache() {
        this.getScopeRequestCache().ifPresent(ScopesRequestCache::clearRequestCache);
    }

    @Nonnull
    public Optional<String> getApplicationNameForRequest() {
        return this.getScopeRequestCache().flatMap(ScopesRequestCache::getApplicationNameForRequest);
    }

    @Nullable
    public ScopesRequestCache.RequestCache getRequestCache() {
        return this.getScopeRequestCache().map(ScopesRequestCache::getRequestCache).orElse(null);
    }

    @Nonnull
    public Set<Scope> getScopes() {
        ScopesRequestCache.RequestCache requestCache = this.getRequestCache();
        if (requestCache == null) {
            return Set.of();
        }
        return requestCache.getScopes();
    }

    public boolean isAnyScopePermitted(Collection<String> scopes) {
        if (this.getScopes().isEmpty()) {
            return false;
        }
        return scopes.isEmpty() || scopes.stream().anyMatch(this::isScopePermitted);
    }

    public boolean isScopePermitted(String scope) {
        return scope == null || this.getScopeRequestCache().map(scopesRequestCache -> scopesRequestCache.isScopePermitted(scope)).orElse(false) != false;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.serviceTracker = this.osgiContainerManager.getServiceTracker(ScopesRequestCache.class.getName());
    }

    public void setRequestCache(@Nullable ScopesRequestCache.RequestCache requestCache) {
        this.getScopeRequestCache().ifPresent(scopesRequestCache -> scopesRequestCache.setRequestCache(requestCache));
    }

    private Optional<ScopesRequestCache> getScopeRequestCache() {
        if (this.serviceTracker != null) {
            return Optional.ofNullable((ScopesRequestCache)this.serviceTracker.getService());
        }
        return Optional.empty();
    }
}

