/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.IncorrectPasswordAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.UserHelper;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class EmbeddedCrowdHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private final I18nService i18nService;
    private final CrowdControl crowdControl;
    private final UserHelper userHelper;

    public EmbeddedCrowdHttpAuthenticationHandler(CrowdControl crowdControl, I18nService i18nService, UserHelper userHelper) {
        this.i18nService = i18nService;
        this.crowdControl = crowdControl;
        this.userHelper = userHelper;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext context) {
        String password;
        String username = context.getUsername();
        String string = password = context.getCredentials() instanceof String ? (String)context.getCredentials() : null;
        if (username == null || password == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isEmpty((CharSequence)password)) {
            throw this.newBadCredentials();
        }
        try {
            InternalNormalUser user = this.userHelper.transformOrCreate(this.crowdControl.authenticate(username, password));
            if (user == null) {
                return null;
            }
            return new AuthenticationResult.Builder((ApplicationUser)user).build();
        }
        catch (IncorrectPasswordAuthenticationException e) {
            throw this.newBadCredentials();
        }
        catch (NoSuchUserException e) {
            return null;
        }
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }

    private IncorrectPasswordAuthenticationException newBadCredentials() {
        throw new IncorrectPasswordAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.auth.failed", new Object[0]));
    }
}

