/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="oauth2RequestContext")
public class Oauth2RequestContext
implements StatefulService {
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    @Autowired
    public Oauth2RequestContext(ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    public Optional<String> getApplicationNameForRequest() {
        return this.scopesRequestCacheDelegate.getApplicationNameForRequest();
    }

    @Nonnull
    public TransferableState getState() {
        final ScopesRequestCache.RequestCache originalThreadScopesRequestCache = this.scopesRequestCacheDelegate.getRequestCache();
        return new TransferableState(){

            public void apply() {
                Oauth2RequestContext.this.scopesRequestCacheDelegate.setRequestCache(originalThreadScopesRequestCache);
            }

            public void remove() {
                Oauth2RequestContext.this.scopesRequestCacheDelegate.clearRequestCache();
            }
        };
    }
}

