/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandlerModuleDescriptor;
import com.atlassian.bitbucket.event.auth.AuthenticationFailureEvent;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginHttpAuthenticationFailureHandler")
public class PluginHttpAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHttpAuthenticationFailureHandler.class);
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpAuthenticationFailureHandler(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        this.eventPublisher.publish((Object)new AuthenticationFailureEvent((Object)this, context.getUsername(), context.getMethod(), context.getAuthenticationException()));
        for (HttpAuthenticationFailureHandler handler : this.getHandlers()) {
            log.debug("onAuthenticationFailure - delegating to {}", (Object)handler.getClass().getName());
            if (!handler.onAuthenticationFailure(context)) continue;
            log.debug("onAuthenticationFailure - {} handled authentication failure", (Object)handler.getClass().getName());
            return true;
        }
        log.debug("onAuthenticationFailure - none of the plugins handled authentication failure");
        return false;
    }

    private Iterable<HttpAuthenticationFailureHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationFailureHandlerModuleDescriptor.class)).collect(Collectors.toList());
    }
}

