/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginHttpAuthenticationHandler")
public class PluginHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHttpAuthenticationHandler.class);
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpAuthenticationHandler(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext context) {
        for (HttpAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            Timer ignored = TimerUtils.start((String)(handlerName + ".performAuthentication"));
            try {
                log.trace("authenticate - trying handler {}", (Object)handlerName);
                AuthenticationResult result = handler.performAuthentication(context);
                if (result == null) continue;
                log.trace("authenticate - handler {} authenticated user {}", (Object)handlerName, (Object)result.getUser().getName());
                AuthenticationResult authenticationResult = result;
                return authenticationResult;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
        log.trace("authenticate - none of the plugins handled authentication");
        return null;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
        for (HttpAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            try {
                Timer ignored = TimerUtils.start((String)(handlerName + ".validateAuthentication"));
                try {
                    log.trace("validateAuthentication - Calling handler {}.validateAuthentication", (Object)handlerName);
                    handler.validateAuthentication(context);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (RuntimeException e) {
                log.debug("{} {} failed validation", new Object[]{HttpAuthenticationHandler.class.getSimpleName(), handlerName, e});
                throw e;
            }
        }
    }

    private Iterable<HttpAuthenticationHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class)).collect(Collectors.toList());
    }
}

