/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandlerModuleDescriptor;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pluginHttpAuthenticationSuccessHandler")
public class PluginHttpAuthenticationSuccessHandler
implements HttpAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginHttpAuthenticationSuccessHandler.class);
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginHttpAuthenticationSuccessHandler(EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) throws ServletException, IOException {
        this.eventPublisher.publish((Object)new AuthenticationSuccessEvent((Object)this, context.getUser().getName(), context.getMethod()));
        for (HttpAuthenticationSuccessHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            log.trace("onAuthenticationSuccess - delegating to {}", (Object)handlerName);
            if (!handler.onAuthenticationSuccess(context)) continue;
            log.trace("onAuthenticationSuccess - {} handled authentication success", (Object)handlerName);
            return true;
        }
        log.trace("onAuthenticationSuccess - none of the plugins handled authentication success");
        return false;
    }

    private Iterable<HttpAuthenticationSuccessHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationSuccessHandlerModuleDescriptor.class)).collect(Collectors.toList());
    }
}

