/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.nav.NavBuilder;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class RedirectingAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    private final NavBuilder navBuilder;

    public RedirectingAuthenticationFailureHandler(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws ServletException, IOException {
        if ("basic".equals(context.getMethod())) {
            return false;
        }
        context.getResponse().sendRedirect(this.buildRedirectUrl(context.getRequest()));
        return true;
    }

    private String buildRedirectUrl(HttpServletRequest request) {
        NavBuilder.Login login = this.navBuilder.login();
        String queryString = request.getParameter("queryString");
        return StringUtils.isNotBlank((CharSequence)queryString) ? login.buildRelative() + "?" + queryString : login.buildRelative();
    }
}

