/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.dmz.crowd.BitbucketResourceType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.stash.internal.auth.HttpAuthUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAccountAuthenticationHandler
implements HttpAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(ServiceAccountAuthenticationHandler.class);
    private final UserService userService;

    public ServiceAccountAuthenticationHandler(UserService userService) {
        this.userService = userService;
    }

    @Nullable
    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
        HttpServletRequest request = authenticationContext.getRequest();
        if (!HttpAuthUtils.isRestCall((HttpServletRequest)request)) {
            return null;
        }
        ServiceAccount serviceAccount = (ServiceAccount)request.getAttribute("serviceAccount");
        if (serviceAccount == null || !serviceAccount.isActive()) {
            return null;
        }
        ServiceUser serviceUser = this.userService.getServiceUserByName("service-account_" + serviceAccount.getId());
        if (serviceUser == null || !serviceUser.isActive()) {
            return null;
        }
        AuthenticationResult.Builder builder = new AuthenticationResult.Builder((ApplicationUser)serviceUser).property("bbs.auth.service-account.id", (Serializable)serviceAccount.getId());
        Map resourceRestrictions = serviceAccount.getResourceRestrictions();
        if (resourceRestrictions != null) {
            resourceRestrictions.forEach((resourceType, resourceSet) -> {
                BitbucketResourceType bitbucketResourceType = BitbucketResourceType.fromId((String)resourceType.getId());
                if (bitbucketResourceType == null) {
                    log.error("Resource type not found {}", (Object)resourceType.getId());
                    return;
                }
                HashSet resourceIds = resourceSet.stream().map(resource -> Integer.parseInt(resource.getId())).collect(Collectors.toCollection(HashSet::new));
                String resourceRestrictionKey = bitbucketResourceType.name() + "-restrictions";
                builder.property(resourceRestrictionKey, (Serializable)resourceIds);
            });
        }
        return builder.build();
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }
}

