/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.websudo;

import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.ip.IPMatcher;
import com.atlassian.stash.internal.auth.websudo.WebSudoIpAllowlistService;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultWebSudoIpAllowlistService
implements WebSudoIpAllowlistService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSudoIpAllowlistService.class);
    private final IPMatcher ipMatcher;
    private final String remoteIpHeader;

    @Autowired
    public DefaultWebSudoIpAllowlistService(@Value(value="${websudo.allowlist.patterns}") String allowListPatterns, @Value(value="${server.tomcat.remoteip.remote-ip-header:X-Forwarded-For}") String remoteIpHeader) {
        this.remoteIpHeader = remoteIpHeader;
        if (StringUtils.isNotBlank((CharSequence)allowListPatterns)) {
            IPMatcher.Builder builder = IPMatcher.builder();
            for (String address : allowListPatterns.split(",")) {
                try {
                    if (!StringUtils.isNotBlank((CharSequence)address)) continue;
                    builder.addPattern(address.trim());
                }
                catch (IllegalArgumentException e) {
                    log.error("Error adding pattern to websudo allowlist: '{}'", (Object)address.trim(), (Object)e);
                }
            }
            this.ipMatcher = builder.build();
        } else {
            this.ipMatcher = null;
        }
    }

    public boolean isIpAddressAllowlisted(@Nonnull HttpServletRequest request) {
        Objects.requireNonNull(request, "request");
        if (this.ipMatcher == null) {
            return true;
        }
        List<String> remoteHosts = this.getRemoteHosts(request);
        try {
            boolean allowed = remoteHosts.stream().allMatch(arg_0 -> ((IPMatcher)this.ipMatcher).matches(arg_0));
            if (!allowed) {
                log.trace("Denying websudo for client address '{}', not on IP address allowlist", (Object)String.join((CharSequence)",", remoteHosts));
            }
            return allowed;
        }
        catch (IllegalArgumentException e) {
            log.error("Error checking IP address against allowlist for values '{}'", (Object)String.join((CharSequence)", ", remoteHosts));
            return false;
        }
    }

    private List<String> getRemoteHosts(HttpServletRequest request) {
        ArrayList<String> remoteHosts = new ArrayList<String>();
        remoteHosts.add(request.getRemoteAddr());
        Enumeration headers = request.getHeaders(this.remoteIpHeader);
        if (headers != null) {
            MoreStreams.streamEnumeration((Enumeration)headers).filter(StringUtils::isNotEmpty).flatMap(forwardedFor -> Stream.of(forwardedFor.split(","))).map(String::trim).filter(StringUtils::isNotEmpty).forEach(remoteHosts::add);
        }
        return remoteHosts;
    }
}

