/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.websudo;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.auth.websudo.BitbucketWebSudoManager;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.stash.internal.auth.websudo.WebSudoIpAllowlistService;
import com.atlassian.stash.internal.auth.websudo.WebSudoSessionService;
import com.atlassian.stash.internal.auth.websudo.WebSudoUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(interfaces={BitbucketWebSudoManager.class, WebSudoManager.class})
@Component(value="webSudoManager")
public class DefaultWebSudoManager
implements BitbucketWebSudoManager {
    public static final String PATH_WEBSUDO = "/websudo";
    @VisibleForTesting
    static final String WEBSUDO_REQUEST_ATTRIBUTE = "bitbucket.websudo.request";
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSudoManager.class);
    private final AuthenticationContext authenticationContext;
    private final FeatureManager featureManager;
    private final PermissionService permissionService;
    private final WebSudoIpAllowlistService webSudoIpAllowlistService;
    private final WebSudoSessionService webSudoSessionService;

    @Autowired
    public DefaultWebSudoManager(AuthenticationContext authenticationContext, FeatureManager featureManager, PermissionService permissionService, WebSudoIpAllowlistService webSudoIpAllowlistService, WebSudoSessionService webSudoSessionService) {
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.permissionService = permissionService;
        this.webSudoIpAllowlistService = webSudoIpAllowlistService;
        this.webSudoSessionService = webSudoSessionService;
    }

    public boolean canExecuteRequest(@Nullable HttpServletRequest request) {
        if (this.cannotHoldWebSudoSession(request)) {
            return true;
        }
        if (this.isWebSudoDisabled()) {
            return true;
        }
        if (this.isWebSudoDenied(request)) {
            return false;
        }
        HttpSession session = request.getSession(false);
        if (this.webSudoSessionService.isValidWebSudoSession(session)) {
            this.webSudoSessionService.setWebSudoSession(session);
            return true;
        }
        return false;
    }

    public boolean cannotExecuteWebSudo(HttpServletRequest request) {
        return this.cannotHoldWebSudoSession(request) || this.isWebSudoDisabled() || this.isWebSudoDenied(request);
    }

    public void createWebSudoSession(@Nullable HttpServletRequest request) {
        if (this.cannotExecuteWebSudo(request)) {
            return;
        }
        this.webSudoSessionService.setWebSudoSession(request.getSession(false));
    }

    public boolean doesRequestRequireWebSudo(@Nullable HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return Boolean.TRUE.equals(request.getAttribute(WEBSUDO_REQUEST_ATTRIBUTE));
    }

    public void enforceWebSudoProtection(@Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        if (request == null || response == null) {
            log.trace("Unable to enforce web sudo protection because request or response is null");
            return;
        }
        if (response.isCommitted()) {
            log.trace("Response is already committed. No need to enforce protection");
            return;
        }
        if (this.canExecuteRequest(request)) {
            log.trace("Already in a web sudo session. No need to enforce protection");
            return;
        }
        if (this.isWebSudoDisabled()) {
            log.trace("Web sudo is disabled. No need to enforce protection");
            return;
        }
        try {
            String originalRequestUrl = DefaultWebSudoManager.getNextUrl(request);
            String redirectUrl = new URIBuilder(request.getContextPath() + PATH_WEBSUDO).addParameter("next", originalRequestUrl).build().toASCIIString();
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to redirect to web sudo login", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("There was an error when trying to build the next or redirect URL", e);
        }
    }

    @Nonnull
    public Optional<Instant> getWebSudoSessionExpiry(@Nullable HttpServletRequest request) {
        if (this.cannotExecuteWebSudo(request)) {
            return Optional.empty();
        }
        return this.webSudoSessionService.getWebSudoSessionExpiry(request.getSession(false));
    }

    public void removeWebSudoSession(@Nullable HttpServletRequest request) {
        if (request == null) {
            return;
        }
        this.webSudoSessionService.clear(request.getSession(false));
    }

    public void willExecuteWebSudoRequest(@Nullable HttpServletRequest request) throws WebSudoSessionException {
        if (!this.canExecuteRequest(request)) {
            throw new WebSudoSessionException("Invalid request: Not in a WebSudo session");
        }
        if (request != null) {
            request.setAttribute(WEBSUDO_REQUEST_ATTRIBUTE, (Object)true);
        }
    }

    private static String getNextUrl(HttpServletRequest request) throws URISyntaxException {
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        String servletPath = StringUtils.stripToEmpty((String)request.getServletPath());
        String pathInfo = StringUtils.stripToEmpty((String)request.getPathInfo());
        Arrays.stream(servletPath.split("/")).forEach(pathPart -> {
            if (StringUtils.isNotBlank((CharSequence)pathPart) && !"mvc".equals(pathPart)) {
                pathBuilder.add(pathPart);
            }
        });
        Arrays.stream(pathInfo.split("/")).forEach(pathPart -> {
            if (StringUtils.isNotBlank((CharSequence)pathPart)) {
                pathBuilder.add(pathPart);
            }
        });
        if (StringUtils.endsWith((CharSequence)pathInfo, (CharSequence)"/") || StringUtils.isBlank((CharSequence)pathInfo) && StringUtils.endsWith((CharSequence)servletPath, (CharSequence)"/")) {
            pathBuilder.add((Object)"");
        }
        URIBuilder originalUrl = new URIBuilder("/" + String.join((CharSequence)"/", (Iterable<? extends CharSequence>)pathBuilder.build()));
        String queryString = StringUtils.trimToNull((String)request.getQueryString());
        if (queryString != null) {
            originalUrl.setCustomQuery(queryString);
        }
        return originalUrl.build().toASCIIString();
    }

    private boolean cannotHoldWebSudoSession(HttpServletRequest request) {
        if (request == null) {
            log.trace("Unable perform web sudo check because request is null");
            return true;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            log.trace("Unable perform web sudo check because session is null");
            return true;
        }
        if (this.authenticationContext.getCurrentUser() instanceof ServiceUser) {
            log.trace("Service users are exempt from web sudo");
            return true;
        }
        if (WebSudoUtils.isExemptAuthType(request)) {
            log.trace("Web sudo cannot be applied to authentication type '{}'", (Object)WebSudoUtils.getAuthType(request));
            return true;
        }
        return false;
    }

    private boolean isWebSudoDenied(HttpServletRequest request) {
        if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            log.trace("Authenticated user does not have admin permission, so cannot execute the request");
            return true;
        }
        if (request != null && !this.webSudoIpAllowlistService.isIpAddressAllowlisted(request)) {
            log.trace("The request was not made from an allowed IP address");
            return true;
        }
        return false;
    }

    private boolean isWebSudoDisabled() {
        if (this.featureManager.isDisabled((Feature)StandardFeature.WEB_SUDO)) {
            log.trace("Web sudo feature is disabled");
            return true;
        }
        return false;
    }
}

