/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.websudo;

import com.atlassian.stash.internal.auth.websudo.WebSudoSessionService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpSession;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Service;

@Service(value="webSudoSessionService")
public class DefaultWebSudoSessionService
implements WebSudoSessionService {
    @VisibleForTesting
    static final String WEB_SUDO_TIMESTAMP = "web-sudo-timestamp";
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSudoSessionService.class);
    private final Clock clock;
    private final Duration timeout;
    private final Duration tolerance;

    @Autowired
    public DefaultWebSudoSessionService(Clock clock, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${websudo.session.timeout:10}") Duration timeout, @DurationUnit(value=ChronoUnit.SECONDS) @Value(value="${websudo.session.tolerance:30}") Duration tolerance) {
        this.clock = clock;
        this.timeout = timeout;
        this.tolerance = tolerance;
    }

    @Override
    public void clear(@Nullable HttpSession session) {
        if (session == null) {
            log.trace("Unable to clear web sudo request because session is null");
            return;
        }
        try {
            session.removeAttribute(WEB_SUDO_TIMESTAMP);
        }
        catch (IllegalStateException e) {
            log.trace("Unable to clear web sudo request session attribute because session is invalidated", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public Optional<Instant> getWebSudoSessionExpiry(@Nullable HttpSession session) {
        if (session == null) {
            return Optional.empty();
        }
        Instant existingTimestamp = DefaultWebSudoSessionService.getExistingWebSudoTimestamp(session);
        if (existingTimestamp == null) {
            return Optional.empty();
        }
        Instant expiry = existingTimestamp.plus(this.timeout);
        if (expiry.isBefore(this.clock.instant())) {
            return Optional.empty();
        }
        return Optional.of(expiry);
    }

    @Override
    public boolean isValidWebSudoSession(@Nullable HttpSession session) {
        if (session == null) {
            log.trace("Unable to validate web sudo session because session is null");
            return false;
        }
        try {
            Instant previousSessionTime = DefaultWebSudoSessionService.getExistingWebSudoTimestamp(session);
            if (previousSessionTime == null) {
                return false;
            }
            if (this.clock.instant().isBefore(previousSessionTime.minus(this.tolerance))) {
                log.trace("It should not be possible for the previous web sudo session to be set in the future, so the session is not a valid web sudo session");
                return false;
            }
            Instant timeoutTime = previousSessionTime.plus(this.timeout);
            if (this.clock.instant().isAfter(timeoutTime.plus(this.tolerance))) {
                log.trace("The web sudo session has expired");
                return false;
            }
            log.trace("The web sudo session is still valid");
            return true;
        }
        catch (IllegalStateException e) {
            log.trace("Unable to validate web sudo session because session is invalidated", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setWebSudoSession(@Nullable HttpSession session) {
        if (session == null) {
            log.warn("Unable to set web sudo request because session is null");
            return;
        }
        try {
            session.setAttribute(WEB_SUDO_TIMESTAMP, (Object)this.clock.millis());
        }
        catch (IllegalStateException e) {
            log.trace("Unable to set web sudo request session attribute because session is invalidated", (Throwable)e);
        }
    }

    private static Instant getExistingWebSudoTimestamp(HttpSession session) {
        Object timestampAttribute = session.getAttribute(WEB_SUDO_TIMESTAMP);
        if (timestampAttribute == null) {
            log.trace("The session does not contain the web sudo timestamp attribute, so the session is not a valid web sudo session");
            return null;
        }
        if (!(timestampAttribute instanceof Long)) {
            log.trace("The session contains a web sudo timestamp attribute, but it is not a long, so the session is not a valid web sudo session");
            return null;
        }
        return Instant.ofEpochMilli((Long)timestampAttribute);
    }
}

