/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.websudo;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.stash.internal.auth.websudo.WebSudoUtils;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class WebSudoInterceptor
implements AsyncHandlerInterceptor {
    private final AuthenticationContext authenticationContext;
    private final WebSudoManager webSudoManager;

    @Autowired
    public WebSudoInterceptor(AuthenticationContext authenticationContext, WebSudoManager webSudoManager) {
        this.authenticationContext = authenticationContext;
        this.webSudoManager = webSudoManager;
    }

    public boolean preHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler) throws Exception {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(handler, "handler");
        if (!this.authenticationContext.isAuthenticated()) {
            return true;
        }
        if (WebSudoUtils.isExemptAuthType(request)) {
            return true;
        }
        if (!WebSudoInterceptor.isWebSudoProtected(request, handler)) {
            return true;
        }
        return this.enforceWebSudoProtection(request, response);
    }

    private static boolean isWebSudoProtected(HttpServletRequest request, Object handler) {
        if (request.getRequestURI().substring(request.getContextPath().length()).startsWith("/mvc/admin")) {
            return true;
        }
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        return handlerMethod.getMethod().isAnnotationPresent(WebSudoRequired.class) || handlerMethod.getBeanType().isAnnotationPresent(WebSudoRequired.class);
    }

    private boolean enforceWebSudoProtection(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        return !response.isCommitted();
    }
}

