/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.websudo;

import com.atlassian.oauth.util.RequestAnnotations;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class WebSudoUtils {
    public static final String SESSION_ATTR_USER_LOGGED_IN_WITH_SSO = "com.atlassian.plugins.authentication.userLoggedInWithSso";
    private static final String WEB_SUDO_REQUEST_PARAM = "websudo";
    private static final Logger log = LoggerFactory.getLogger(WebSudoUtils.class);

    private WebSudoUtils() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " only contains static utility methods and should not be instantiated.");
    }

    public static String getAuthType(@Nonnull HttpServletRequest request) {
        if (WebSudoUtils.isRequestAuthenticatedWithSsoAuth(request)) {
            return "SSO";
        }
        if (WebSudoUtils.isRequestAuthenticatedWithBasicAuth(request)) {
            return "Basic";
        }
        if (WebSudoUtils.isRequestAuthenticatedWithBearerAuth()) {
            return "Bearer";
        }
        if (WebSudoUtils.isRequestAuthenticatedWithJwtAuth(request)) {
            return "JWT";
        }
        return null;
    }

    public static boolean isExemptAuthType(HttpServletRequest request) {
        return WebSudoUtils.isRequestAuthenticatedWithBasicAuth(request) || WebSudoUtils.isRequestAuthenticatedWithBearerAuth() || WebSudoUtils.isRequestAuthenticatedWithJwtAuth(request) || WebSudoUtils.isRequestAuthenticatedWithSsoAuth(request) || WebSudoUtils.isRequestAuthenticatedWithOAuth(request);
    }

    public static boolean isWebSudoAuthenticationRequest(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return Boolean.parseBoolean(request.getParameter(WEB_SUDO_REQUEST_PARAM));
    }

    private static boolean isRequestAuthenticatedWithBasicAuth(HttpServletRequest request) {
        return "basic".equalsIgnoreCase(String.valueOf(request.getAttribute("com.atlassian.stash.internal.auth.method")));
    }

    private static boolean isRequestAuthenticatedWithBearerAuth() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof StashUserAuthenticationToken)) {
            return false;
        }
        return ((StashUserAuthenticationToken)authentication).getProperties().get("bbs.security.token.id") != null;
    }

    private static boolean isRequestAuthenticatedWithJwtAuth(HttpServletRequest request) {
        return request.getAttribute("jwt.subject") != null;
    }

    private static boolean isRequestAuthenticatedWithOAuth(HttpServletRequest request) {
        return RequestAnnotations.isOAuthRequest((HttpServletRequest)request);
    }

    private static boolean isRequestAuthenticatedWithSsoAuth(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        try {
            return session != null && Boolean.TRUE.equals(session.getAttribute(SESSION_ATTR_USER_LOGGED_IN_WITH_SSO));
        }
        catch (IllegalStateException e) {
            log.debug("Cannot get attribute for invalidated session", (Throwable)e);
            return false;
        }
    }
}

