/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.autodecline;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.autodecline.DmzAutoDeclineService;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="autoDeclineJob")
@DefaultApplicationMode
public class AutoDeclineJob
implements ScheduledJobSource {
    private static final Duration EXTRA_JOB_DELAY = Duration.ofMinutes(15L);
    private static final Duration FIRST_RUN_DELAY = Duration.ofMinutes(15L);
    private static final JobId JOB_ID = JobId.of((String)AutoDeclineJob.class.getSimpleName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)AutoDeclineJob.class.getName());
    private static final String LOCK_NAME = AutoDeclineJob.class.getSimpleName();
    private static final Logger log = LoggerFactory.getLogger(AutoDeclineJob.class);
    private final DmzAutoDeclineService autoDeclineService;
    private final Duration interval;
    private final LockService lockService;

    @Autowired
    public AutoDeclineJob(DmzAutoDeclineService autoDeclineService, @Value(value="${pullrequest.auto.decline.job.interval}") long intervalInHours, LockService lockService) {
        this.autoDeclineService = autoDeclineService;
        this.lockService = lockService;
        this.interval = Duration.ofHours(intervalInHours);
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        AutoDeclineJobRunner jobRunner = new AutoDeclineJobRunner(schedulerService);
        schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters((Map)ImmutableMap.of((Object)"feature", (Object)StandardFeature.PULL_REQUEST_AUTO_DECLINE)).withSchedule(Schedule.forInterval((long)this.interval.toMillis(), (Date)Date.from(ZonedDateTime.now().plus(FIRST_RUN_DELAY).toInstant()))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(JOB_ID);
        schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private class AutoDeclineJobRunner
    implements JobRunner {
        private final SchedulerService schedulerService;

        public AutoDeclineJobRunner(SchedulerService schedulerService) {
            this.schedulerService = schedulerService;
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try (LockGuard guard = LockGuard.tryLock((Lock)AutoDeclineJob.this.lockService.getLock(LOCK_NAME));){
                if (guard == null) {
                    log.debug("Unable to acquire lock for automatically declining inactive pull requests. Job may be already running on another node.");
                } else {
                    log.debug("Automatically declining inactive pull requests.");
                    boolean allProcessed = AutoDeclineJob.this.autoDeclineService.declineInactivePullRequests(Instant.now());
                    if (allProcessed) {
                        log.debug("All inactive pull requests have been declined.");
                    } else {
                        log.debug("Limit for number of pull requests that can be declined in this job has been reached but there are still more open pull requests to process. Scheduling additional decline job in {} minutes.", (Object)EXTRA_JOB_DELAY.toMinutes());
                        try {
                            this.schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.runOnce((Date)new Date(System.currentTimeMillis() + EXTRA_JOB_DELAY.toMillis()))));
                        }
                        catch (SchedulerServiceException e) {
                            log.debug("Unable to schedule additional decline job. The next regularly scheduled auto decline job will continue the process.");
                        }
                    }
                }
            }
            return JobRunnerResponse.success();
        }
    }
}

