/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.autodecline;

import com.atlassian.bitbucket.dmz.autodecline.AutoDeclineSettings;
import com.atlassian.bitbucket.dmz.autodecline.DmzAutoDeclineService;
import com.atlassian.bitbucket.dmz.autodecline.DmzAutoDeclineSettingsService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.pull.PullRequestActivitySummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.PullRequestDeclineRequest;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.autodecline.AnalyticsPullRequestAutoDeclinedEvent;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalUserService;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=DmzAutoDeclineService.class)
@RequireFeature(value=StandardFeature.PULL_REQUEST_AUTO_DECLINE)
@Service(value="autoDeclineService")
public class DefaultAutoDeclineService
implements DmzAutoDeclineService {
    static final String DECLINE_COMMENT_NO_WEEKS_KEY = "bitbucket.pull.autodecline.decline.comment.noweeks";
    static final String DECLINE_COMMENT_WEEKS_KEY = "bitbucket.pull.autodecline.decline.comment.weeks";
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoDeclineService.class);
    private final DmzAutoDeclineSettingsService autoDeclineSettingsService;
    private final long declineLimit;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PullRequestActivityDao pullRequestActivityDao;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final InternalUserService userService;
    private final TransactionTemplate withNewTransaction;

    @Autowired
    public DefaultAutoDeclineService(DmzAutoDeclineSettingsService autoDeclineSettingsService, @Value(value="${pullrequest.auto.decline.limit}") long declineLimit, EventPublisher eventPublisher, I18nService i18nService, PullRequestActivityDao pullRequestActivityDao, PullRequestService pullRequestService, RepositoryService repositoryService, SecurityService securityService, PlatformTransactionManager transactionManager, InternalUserService userService) {
        this.autoDeclineSettingsService = autoDeclineSettingsService;
        this.declineLimit = declineLimit;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.pullRequestActivityDao = pullRequestActivityDao;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.userService = userService;
        this.withNewTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Transactional(readOnly=true)
    public boolean declineInactivePullRequests(@Nonnull Instant now) {
        return (Boolean)this.securityService.impersonating((ApplicationUser)this.userService.getSystemServiceUser(), "Declining inactive pull requests").withPermission(Permission.REPO_READ).call(() -> {
            try (Stream summaries = this.pullRequestActivityDao.streamActivitySummaryForOpenPullRequests();){
                DeclineIfInactive declineIfInactive = new DeclineIfInactive(now, this.declineLimit);
                Boolean bl = summaries.allMatch(declineIfInactive);
                return bl;
            }
        });
    }

    private class DeclineIfInactive
    implements Predicate<PullRequestActivitySummary> {
        private final long declineLimit;
        private final Instant now;
        private int declined;
        private Instant cutoff;
        private boolean enabled;
        private int previousRepositoryId;

        public DeclineIfInactive(Instant now, long declineLimit) {
            this.declineLimit = declineLimit;
            this.now = now;
        }

        @Override
        public boolean test(PullRequestActivitySummary summary) {
            if ((long)this.declined >= this.declineLimit) {
                return false;
            }
            int repositoryId = summary.getRepositoryId();
            if (this.previousRepositoryId != repositoryId) {
                this.previousRepositoryId = repositoryId;
                Repository repository = DefaultAutoDeclineService.this.repositoryService.getById(repositoryId);
                if (repository == null) {
                    this.enabled = false;
                } else {
                    AutoDeclineSettings settings = DefaultAutoDeclineService.this.autoDeclineSettingsService.getOrDefault((Scope)new RepositoryScope(repository));
                    this.cutoff = this.now.minus(Period.ofWeeks(settings.getInactivityWeeks()));
                    this.enabled = settings.getEnabled();
                }
            }
            Instant latest = summary.getLatest().toInstant();
            if (this.enabled && latest.isBefore(this.cutoff)) {
                DefaultAutoDeclineService.this.withNewTransaction.execute(status -> {
                    this.declinePullRequest(summary.getId(), repositoryId, summary.getVersion(), this.commentFor(latest));
                    return null;
                });
                DefaultAutoDeclineService.this.eventPublisher.publish((Object)new AnalyticsPullRequestAutoDeclinedEvent(this, this.weeksBetween(latest, this.now), summary.getId(), repositoryId));
            }
            return true;
        }

        private String commentFor(Instant latest) {
            long inactiveWeeks = this.weeksBetween(latest, this.now);
            return inactiveWeeks < 1L ? DefaultAutoDeclineService.this.i18nService.getMessage(DefaultAutoDeclineService.DECLINE_COMMENT_NO_WEEKS_KEY, new Object[0]) : DefaultAutoDeclineService.this.i18nService.getMessage(DefaultAutoDeclineService.DECLINE_COMMENT_WEEKS_KEY, new Object[]{inactiveWeeks});
        }

        private void declinePullRequest(long pullRequestId, int repositoryId, int version, String comment) {
            log.debug("Declining inactive pull request [{}] in repository [{}]", (Object)pullRequestId, (Object)repositoryId);
            try {
                DefaultAutoDeclineService.this.pullRequestService.decline(new PullRequestDeclineRequest.Builder(repositoryId, pullRequestId, version).comment(comment).build());
                ++this.declined;
            }
            catch (IllegalPullRequestStateException e) {
                log.debug("[{}:{}@{}] Skipping auto-decline, current state prevents declining", new Object[]{repositoryId, pullRequestId, version});
            }
            catch (PullRequestOutOfDateException e) {
                if (e.getPullRequest() == null) {
                    log.debug("[{}:{}@{}] Skipping auto-decline, pull request has been updated", new Object[]{repositoryId, pullRequestId, version});
                }
                log.debug("[{}:{}@{}] Skipping auto-decline, pull request has been updated to version [{}]", new Object[]{repositoryId, pullRequestId, version, e.getPullRequest().getVersion()});
            }
            catch (Exception e) {
                log.warn("[{}:{}@{}] Failed to auto-decline. Exception: ", new Object[]{repositoryId, pullRequestId, version, e});
            }
        }

        private long weeksBetween(Instant from, Instant to) {
            return ChronoUnit.WEEKS.between(ZonedDateTime.ofInstant(from, ZoneId.systemDefault()), ZonedDateTime.ofInstant(to, ZoneId.systemDefault()));
        }
    }
}

