/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.autodecline;

import com.atlassian.bitbucket.dmz.autodecline.AutoDeclineSettings;
import com.atlassian.bitbucket.dmz.autodecline.DmzAutoDeclineSettingsService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsCreatedEvent;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsDao;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsDeletedEvent;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsUpdatedEvent;
import com.atlassian.stash.internal.autodecline.InternalAutoDeclineSettings;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzAutoDeclineSettingsService.class)
@RequireFeature(value=StandardFeature.PULL_REQUEST_AUTO_DECLINE)
@Service(value="autoDeclineSettingsService")
@Transactional(readOnly=true)
public class DefaultAutoDeclineSettingsService
implements DmzAutoDeclineSettingsService {
    private final AutoDeclineSettingsDao autoDeclineSettingsDao;
    private final EventPublisher eventPublisher;
    private final AutoDeclineSettings globalSettings;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;

    @Autowired
    public DefaultAutoDeclineSettingsService(AutoDeclineSettingsDao autoDeclineSettingsDao, EventPublisher eventPublisher, final @Value(value="${pullrequest.auto.decline.settings.global.enabled}") boolean globalEnabled, final @Value(value="${pullrequest.auto.decline.settings.global.inactivityWeeks}") int globalInactivityWeeks, I18nService i18nService, PermissionValidationService permissionValidationService) {
        this.autoDeclineSettingsDao = autoDeclineSettingsDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.globalSettings = new AutoDeclineSettings(){

            public boolean getEnabled() {
                return globalEnabled;
            }

            public int getInactivityWeeks() {
                return DmzAutoDeclineSettingsService.VALID_INACTIVITY_WEEKS.contains(globalInactivityWeeks) ? globalInactivityWeeks : 4;
            }

            @Nonnull
            public Scope getScope() {
                return new GlobalScope();
            }
        };
    }

    @Nonnull
    @Transactional
    public AutoDeclineSettings createOrUpdate(@Nonnull Scope scope, int inactivityWeeks, boolean enabled) {
        this.validateAdminPermission(Objects.requireNonNull(scope, "scope"));
        if (!VALID_INACTIVITY_WEEKS.contains(inactivityWeeks)) {
            throw new IllegalArgumentException(this.i18nService.getMessage("bitbucket.pull.autodecline.error.invalidinactivityweeks", new Object[]{VALID_INACTIVITY_WEEKS}));
        }
        Optional settings = this.autoDeclineSettingsDao.findByScope(scope);
        if (settings.isPresent()) {
            InternalAutoDeclineSettings oldSettings = new InternalAutoDeclineSettings.Builder((InternalAutoDeclineSettings)settings.get()).build();
            AutoDeclineSettings newSettings = (AutoDeclineSettings)this.autoDeclineSettingsDao.update((Object)new InternalAutoDeclineSettings.Builder(oldSettings).enabled(enabled).inactivityWeeks(inactivityWeeks).build());
            this.eventPublisher.publish((Object)new AutoDeclineSettingsUpdatedEvent(this, newSettings, (AutoDeclineSettings)oldSettings));
            return newSettings;
        }
        AutoDeclineSettings newSettings = (AutoDeclineSettings)this.autoDeclineSettingsDao.create((Object)new InternalAutoDeclineSettings.Builder(inactivityWeeks, scope, enabled).build());
        this.eventPublisher.publish((Object)new AutoDeclineSettingsCreatedEvent(this, newSettings));
        return newSettings;
    }

    @Transactional
    public void delete(@Nonnull Scope scope) {
        this.validateAdminPermission(Objects.requireNonNull(scope, "scope"));
        Optional settings = this.autoDeclineSettingsDao.findByScope(scope);
        this.autoDeclineSettingsDao.deleteByScope(scope);
        if (settings.isPresent()) {
            this.eventPublisher.publish((Object)new AutoDeclineSettingsDeletedEvent(this, (AutoDeclineSettings)settings.get()));
        }
    }

    @Nonnull
    public AutoDeclineSettings getOrDefault(@Nonnull Scope scope) {
        this.validateReadPermission(Objects.requireNonNull(scope, "scope"));
        return this.autoDeclineSettingsDao.findInheritedByScopes(scope).map(AutoDeclineSettings.class::cast).orElse(this.globalSettings);
    }

    private void validateAdminPermission(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope globalScope) {
                throw new IllegalArgumentException(DefaultAutoDeclineSettingsService.this.i18nService.getMessage("bitbucket.pull.autodecline.error.invalidscope", new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultAutoDeclineSettingsService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultAutoDeclineSettingsService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateReadPermission(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull GlobalScope globalScope) {
                throw new IllegalArgumentException(DefaultAutoDeclineSettingsService.this.i18nService.getMessage("bitbucket.pull.autodecline.error.invalidscope", new Object[0]));
            }

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultAutoDeclineSettingsService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_VIEW);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultAutoDeclineSettingsService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_READ);
                return null;
            }
        });
    }
}

