/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.avatar.AvatarStoreException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.SimpleAvatarSupplier;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.RequestLocalMap;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.AvatarUrlDecorator;
import com.atlassian.stash.internal.avatar.FallbackAvatarSource;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=AvatarService.class)
@NotProfiled
@Service(value="avatarService")
@Transactional(propagation=Propagation.SUPPORTS)
public class ConfigurableAvatarService
extends AbstractService
implements InternalAvatarService {
    public static final String DEFAULT_SOURCE = "default";
    public static final String DISABLED_SOURCE = "disabled";
    private static final String CACHE_NAME = InternalAvatarService.class.getName();
    private static final Logger log = LoggerFactory.getLogger(ConfigurableAvatarService.class);
    private static final Pattern PATTERN_DATA_URI = Pattern.compile("data:([^;]+);base64,([A-Za-z0-9+/]+)=*$");
    private final CachedReference<AvatarSource> activeSource;
    private final AuthenticationContext authenticationContext;
    private final boolean avatarAnonymousAccessAllowed;
    private final RequestLocalMap<AvatarKey, String> avatarCache;
    private final AvatarSource defaultSource;
    private final FallbackAvatarSource fallbackSource;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final InternalApplicationPropertiesService propertiesService;
    private final AvatarRepository repository;
    private final AvatarUrlDecorator urlDecorator;

    @Autowired
    public ConfigurableAvatarService(I18nService i18nService, NavBuilder navBuilder, InternalApplicationPropertiesService propertiesService, AvatarRepository repository, CacheFactory cacheFactory, AvatarUrlDecorator urlDecorator, @Qualifier(value="urlAvatarSource") AvatarSource defaultSource, FallbackAvatarSource fallbackSource, RequestManager requestManager, AuthenticationContext authenticationContext, @Value(value="${avatar.anonymous.access}") boolean avatarAnonymousAccessAllowed) {
        this.authenticationContext = authenticationContext;
        this.avatarAnonymousAccessAllowed = avatarAnonymousAccessAllowed;
        this.defaultSource = defaultSource;
        this.fallbackSource = fallbackSource;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.repository = repository;
        this.urlDecorator = urlDecorator;
        this.activeSource = this.createCachedReference(cacheFactory);
        this.avatarCache = new RequestLocalMap(requestManager);
    }

    @Nonnull
    @Unsecured(value="Creating a supplier from a data URI requires no specific permission")
    public AvatarSupplier createSupplierFromDataUri(@Nonnull String uri) {
        Objects.requireNonNull(uri, "uri");
        uri = uri.replaceAll("\\s", "").replace('-', '+').replace('_', '/');
        Matcher matcher = PATTERN_DATA_URI.matcher(uri);
        if (!matcher.matches()) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.invaliddatauri", new Object[0]));
        }
        String contentType = matcher.group(1);
        String data = matcher.group(2);
        ByteArrayInputStream base64Data = new ByteArrayInputStream(StringUtils.getBytesUtf8((String)data));
        return new SimpleAvatarSupplier(contentType, (InputStream)new Base64InputStream((InputStream)base64Data));
    }

    @PreAuthorize(value="hasUserPermission(#user, 'USER_ADMIN')")
    public void deleteForUser(@Nonnull ApplicationUser user) {
        this.repository.delete(AvatarType.USER, user.getId());
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForProject(@Nonnull Project project, int size) {
        Objects.requireNonNull(project, "project");
        if (this.avatarAnonymousAccessAllowed || this.authenticationContext.isAuthenticated()) {
            return this.repository.load(AvatarType.PROJECT, project.getId(), size);
        }
        return this.getProjectDefault(size);
    }

    @Nonnull
    @Unsecured(value="Method handles input from unauthenticated users")
    public CacheableAvatarSupplier getForUser(@Nonnull ApplicationUser user, int size) {
        Objects.requireNonNull(user, "user");
        if (this.avatarAnonymousAccessAllowed || this.authenticationContext.isAuthenticated()) {
            return this.repository.load(AvatarType.USER, user.getId(), size);
        }
        return this.getUserDefault(size);
    }

    @Unsecured(value="Anyone is allowed to check the maximum avatar upload size")
    public long getMaxUploadSize() {
        return this.repository.getMaxSize();
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getProjectDefault(int size) {
        return this.repository.loadDefault(AvatarType.PROJECT, size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        Objects.requireNonNull(person, "person");
        Objects.requireNonNull(request, "request");
        return (String)this.avatarCache.get((Object)AvatarKey.forPerson(person, request), () -> this.doGetUrlForPerson(person, request));
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForProject(@Nonnull Project project, @Nonnull AvatarRequest request) {
        Objects.requireNonNull(project, "project");
        return (String)this.avatarCache.get((Object)((AvatarKey)project.accept((ProjectVisitor)new AvatarKeyVisitor(request))), () -> (String)project.accept((ProjectVisitor)new AvatarProjectVisitor(request)));
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForReviewerGroup(@Nonnull ReviewerGroup group, @Nonnull AvatarRequest request) {
        return this.fallbackSource.getUrlForReviewerGroup(group, request);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getUserDefault(int size) {
        return this.repository.loadDefault(AvatarType.USER, size);
    }

    @Unsecured(value="Anyone is allowed to check whether avatars are enabled")
    public boolean isEnabled() {
        return this.activeSource.get() == this.defaultSource;
    }

    @Unsecured(value="Anyone is allowed to check whether a user's avatar is locally stored")
    public boolean isLocalForUser(@Nonnull ApplicationUser user) {
        return this.repository.isStored(AvatarType.USER, Objects.requireNonNull(user, "user").getId());
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.cleanup(AvatarType.PROJECT, event.getProject().getId());
        this.urlDecorator.invalidate(event.getProject());
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        this.cleanup(AvatarType.USER, event.getDeletedUser().getId());
        this.urlDecorator.invalidate(event.getDeletedUser());
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void saveForProject(@Nonnull Project project, @Nonnull AvatarSupplier supplier) {
        Objects.requireNonNull(project, "project");
        this.repository.store(AvatarType.PROJECT, project.getId(), supplier);
        this.urlDecorator.invalidate(project);
    }

    @PreAuthorize(value="hasUserPermission(#user, 'USER_ADMIN')")
    public void saveForUser(@Nonnull ApplicationUser user, @Nonnull AvatarSupplier supplier) {
        Objects.requireNonNull(user, "user");
        this.repository.store(AvatarType.USER, user.getId(), supplier);
        this.urlDecorator.invalidate(user);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setEnabled(boolean enabled) {
        this.propertiesService.setAvatarSource(enabled ? DEFAULT_SOURCE : DISABLED_SOURCE);
        SpringTransactionUtils.invokeAfterCommit(() -> this.activeSource.reset());
    }

    private void cleanup(AvatarType type, int id) {
        try {
            this.repository.delete(type, id);
        }
        catch (AvatarStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not cleanup avatars for {} {}", new Object[]{type, id, e});
            }
            log.warn("Could not cleanup avatars for {} {}: {}", new Object[]{type, id, e.getMessage()});
        }
    }

    private CachedReference<AvatarSource> createCachedReference(CacheFactory cacheFactory) {
        Supplier cacheLoader = () -> {
            if (DISABLED_SOURCE.equals(this.propertiesService.getAvatarSource())) {
                return this.fallbackSource;
            }
            return this.defaultSource;
        };
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build();
        return cacheFactory.getCachedReference(CACHE_NAME, cacheLoader, cacheSettings);
    }

    @Nonnull
    private String doGetUrlForPerson(Person person, AvatarRequest request) {
        ApplicationUser user;
        if (person instanceof ApplicationUser && this.repository.isStored(AvatarType.USER, (user = (ApplicationUser)person).getId())) {
            NavBuilder.Builder builder = this.navBuilder.user(user).avatar(request.getSize());
            this.urlDecorator.decorate(builder, user);
            return request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }
        return ((AvatarSource)this.activeSource.get()).getUrlForPerson(person, request);
    }

    private static class AvatarKey {
        private final Object owner;
        private final AvatarRequest request;

        private AvatarKey(Object owner, AvatarRequest request) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.request = Objects.requireNonNull(request, "request");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            AvatarKey that = (AvatarKey)other;
            return this.owner.equals(that.owner) && this.request.equals((Object)that.request);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.request);
        }

        static AvatarKey forPerson(Person person, AvatarRequest request) {
            return new AvatarKey(AvatarKey.personId(person), request);
        }

        static AvatarKey forProject(Project project, AvatarRequest request) {
            return new AvatarKey(project.getKey(), request);
        }

        @Nonnull
        private static Object personId(Person person) {
            if (person instanceof ApplicationUser) {
                return ((ApplicationUser)person).getId();
            }
            return org.apache.commons.lang3.StringUtils.defaultString((String)person.getEmailAddress());
        }
    }

    private static class AvatarKeyVisitor
    implements ProjectVisitor<AvatarKey> {
        private final AvatarRequest request;

        private AvatarKeyVisitor(AvatarRequest request) {
            this.request = Objects.requireNonNull(request, "request");
        }

        public AvatarKey visit(@Nonnull Project project) {
            return AvatarKey.forProject(project, this.request);
        }

        public AvatarKey visit(@Nonnull PersonalProject project) {
            return AvatarKey.forPerson((Person)project.getOwner(), this.request);
        }
    }

    private class AvatarProjectVisitor
    implements ProjectVisitor<String> {
        private final AvatarRequest request;

        private AvatarProjectVisitor(AvatarRequest request) {
            this.request = Objects.requireNonNull(request, "request");
        }

        public String visit(@Nonnull Project project) {
            NavBuilder.Builder builder = ConfigurableAvatarService.this.navBuilder.project(project).avatar(this.request.getSize());
            ConfigurableAvatarService.this.urlDecorator.decorate(builder, project);
            return this.request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }

        public String visit(@Nonnull PersonalProject project) {
            return ConfigurableAvatarService.this.doGetUrlForPerson((Person)project.getOwner(), this.request);
        }
    }
}

