/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AbstractAvatarSupplier;
import com.atlassian.bitbucket.avatar.AvatarException;
import com.atlassian.bitbucket.avatar.AvatarLoadException;
import com.atlassian.bitbucket.avatar.AvatarResizeException;
import com.atlassian.bitbucket.avatar.AvatarStoreException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.DelegatingCacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.UnsupportedAvatarException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.google.common.collect.Iterators;
import com.google.common.io.Closeables;
import io.atlassian.util.concurrent.ConcurrentOperationMap;
import io.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import jakarta.annotation.Nonnull;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="avatarRepository")
public class DiskAvatarRepository
implements AvatarRepository {
    public static final String AVATARS_PATH = "avatars";
    public static final String AVATAR_FORMAT = "png";
    public static final String FILE_EXTENSION = ".png";
    public static final int MINIMUM_MAX_DIMENSION = 256;
    public static final long MINIMUM_MAX_SIZE = 102400L;
    public static final String ORIGINAL_FILE = "original.png";
    public static final int ORIGINAL_SIZE = -1;
    private static final Logger log = LoggerFactory.getLogger(DiskAvatarRepository.class);
    private final Path avatarDir;
    private final I18nService i18nService;
    private final ConcurrentOperationMap<ResizeKey, Path> operationMap;
    private final long systemTimestamp;
    private long maxDimension;
    private long maxSize;

    @Autowired
    public DiskAvatarRepository(I18nService i18nService, ApplicationPropertiesService propertiesService, StorageService storageService) {
        this.i18nService = i18nService;
        this.avatarDir = MoreFiles.mkdir((Path)storageService.getDataDir(), (String)AVATARS_PATH);
        this.operationMap = new ConcurrentOperationMapImpl();
        Date timestamp = propertiesService.getBuildTimestamp();
        this.systemTimestamp = timestamp == null ? -1L : timestamp.getTime();
    }

    public void delete(@Nonnull AvatarType type, int id) {
        Objects.requireNonNull(type, "type");
        String avatarId = Integer.toString(id);
        Path instanceDir = MoreFiles.resolve((Path)this.avatarDir, (String)type.getDirectoryName(), (String[])new String[]{avatarId});
        try {
            this.requireAvatarPath(instanceDir);
            MoreFiles.deleteRecursively((Path)instanceDir);
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.removalfailed", new Object[]{type.name(), avatarId}));
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getVersionId(@Nonnull AvatarType type, int id) {
        return this.load(type, id, -1).getTimestamp();
    }

    public boolean isStored(@Nonnull AvatarType type, int id) {
        block10: {
            boolean bl;
            block9: {
                Objects.requireNonNull(type, "type");
                String avatarId = Integer.toString(id);
                Path original = MoreFiles.resolve((Path)this.avatarDir, (String)type.getDirectoryName(), (String[])new String[]{avatarId, ORIGINAL_FILE});
                InputStream ignored2 = this.open(original);
                try {
                    bl = true;
                    if (ignored2 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored2 != null) {
                            try {
                                ignored2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException | NoSuchFileException ignored2) {
                        break block10;
                    }
                    catch (IOException e) {
                        log.warn("Opening {} avatar {} for ID {} threw an unexpected exception", new Object[]{type, original.toAbsolutePath(), id, e});
                    }
                }
                ignored2.close();
            }
            return bl;
        }
        return false;
    }

    @Nonnull
    public CacheableAvatarSupplier load(@Nonnull AvatarType type, int id, int size) {
        String avatarId;
        block14: {
            LoadedAvatarSupplier loadedAvatarSupplier;
            block13: {
                Objects.requireNonNull(type, "type");
                avatarId = Integer.toString(id);
                size = DiskAvatarRepository.normalizeSize(size);
                Path original = MoreFiles.resolve((Path)this.avatarDir, (String)type.getDirectoryName(), (String[])new String[]{avatarId, ORIGINAL_FILE});
                InputStream originalStream2 = this.open(original);
                try {
                    Path avatar;
                    if (size == -1) {
                        avatar = original;
                    } else {
                        ResizeKey key = new ResizeKey(type, avatarId, size);
                        try {
                            avatar = (Path)this.operationMap.runOperation((Object)key, (Callable)new ResizeAvatarCallable(this.i18nService, original, originalStream2, size));
                        }
                        catch (ExecutionException e) {
                            throw (AvatarException)e.getCause();
                        }
                    }
                    loadedAvatarSupplier = new LoadedAvatarSupplier(avatar);
                    if (originalStream2 == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (originalStream2 != null) {
                            try {
                                originalStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException | NoSuchFileException originalStream2) {
                        break block14;
                    }
                    catch (IOException e) {
                        throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.unreadableimage", new Object[0]), (Throwable)e);
                    }
                }
                originalStream2.close();
            }
            return loadedAvatarSupplier;
        }
        return this.defaultSupplier(type.loadDefault(avatarId, DiskAvatarRepository.normalizeDefaultSize(size)));
    }

    @Nonnull
    public CacheableAvatarSupplier loadDefault(@Nonnull AvatarType type, int size) {
        size = DiskAvatarRepository.normalizeDefaultSize(size);
        return this.defaultSupplier(type.loadFixedDefault(size));
    }

    @Value(value="${avatar.max.dimension}")
    public void setMaxDimension(int maxDimension) {
        if (maxDimension < 256) {
            log.warn("The configured max dimension for avatars, [{}] pixels, is too small and will be ignored. It will be defaulted to {} pixels", (Object)maxDimension, (Object)256);
            maxDimension = 256;
        }
        this.maxDimension = maxDimension;
    }

    @Value(value="${avatar.max.size}")
    public void setMaxSize(long maxSize) {
        if (maxSize < 102400L) {
            log.warn("The configured max file size for avatars, [{}], is too small and will be ignored. It will be defaulted to {}", (Object)NumberUtils.formatSize((double)maxSize), (Object)NumberUtils.formatSize((double)102400.0));
        }
        this.maxSize = maxSize;
    }

    public void store(@Nonnull AvatarType type, int id, @Nonnull AvatarSupplier supplier) {
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(type, "type");
        String avatarId = Integer.toString(id);
        BufferedImage avatar = this.readAvatar(supplier);
        Path typeDir = MoreFiles.mkdir((Path)this.avatarDir, (String)type.getDirectoryName());
        Path instanceDir = MoreFiles.mkdir((Path)typeDir, (String)avatarId);
        if (Files.isDirectory(instanceDir, new LinkOption[0])) {
            try {
                this.requireAvatarPath(instanceDir);
                MoreFiles.cleanDirectory((Path)instanceDir);
            }
            catch (IOException e) {
                throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.cleanupfailed", new Object[]{type.name()}));
            }
        }
        this.writeAvatar(avatar, instanceDir.resolve(ORIGINAL_FILE));
    }

    private static int normalizeDefaultSize(int size) {
        if ((size = DiskAvatarRepository.normalizeSize(size)) == -1) {
            return 256;
        }
        return size;
    }

    private static int normalizeSize(int size) {
        if (size < 0) {
            return -1;
        }
        if (size > 128) {
            return 256;
        }
        if (size > 96) {
            return 128;
        }
        if (size > 64) {
            return 96;
        }
        if (size > 48) {
            return 64;
        }
        return 48;
    }

    @Nonnull
    private CacheableAvatarSupplier defaultSupplier(@Nonnull AvatarSupplier supplier) {
        return new DelegatingCacheableAvatarSupplier(Objects.requireNonNull(supplier, "supplier"), this.systemTimestamp);
    }

    private BufferedImage readAvatar(AvatarSupplier supplier) {
        BufferedImage avatar;
        InputStream rawStream;
        try {
            rawStream = supplier.open();
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.supplierfailed", new Object[0]), (Throwable)e);
        }
        if (rawStream == null) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.nostream", new Object[0]));
        }
        ImageReader reader = null;
        try {
            ImageInputStream imageStream = ImageIO.createImageInputStream(rawStream);
            Iterator<ImageReader> readerIterator = ImageIO.getImageReaders(imageStream);
            reader = (ImageReader)Iterators.getNext(readerIterator, null);
            if (reader == null) {
                throw new UnsupportedAvatarException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.unsupportedcontenttype", new Object[0]));
            }
            reader.setInput(imageStream);
            int height = reader.getHeight(0);
            int width = reader.getWidth(0);
            if ((long)height > this.maxDimension || (long)width > this.maxDimension) {
                throw new UnsupportedAvatarException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.unsupporteddimensions", new Object[]{String.valueOf(width), String.valueOf(height), String.valueOf(this.maxDimension)}));
            }
            avatar = reader.read(0);
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.unreadableimage", new Object[0]), (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            Closeables.closeQuietly((InputStream)rawStream);
        }
        return avatar;
    }

    private void writeAvatar(BufferedImage avatar, Path file) {
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            ImageIO.write((RenderedImage)avatar, AVATAR_FORMAT, outputStream);
        }
        catch (IOException e) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.writefailed", new Object[0]), (Throwable)e);
        }
        long size = MoreFiles.size((Path)file);
        if (size > this.maxSize) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                log.warn("Oversized avatar {} ({}) could not be deleted; will attempt to delete on exit", (Object)file.toAbsolutePath(), (Object)NumberUtils.formatSize((double)size));
                MoreFiles.deleteOnExit((Path)file);
            }
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.store.oversized", new Object[]{NumberUtils.formatSize((double)size), NumberUtils.formatSize((double)this.maxSize)}));
        }
    }

    private InputStream open(Path avatarFile) throws IOException {
        if (!MoreFiles.isWithin((Path)avatarFile, (Path)this.avatarDir)) {
            throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.invalidpath", new Object[0]));
        }
        return Files.newInputStream(avatarFile, new OpenOption[0]);
    }

    private void requireAvatarPath(Path location) throws IOException {
        if (!MoreFiles.isWithin((Path)location, (Path)this.avatarDir)) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.invalidpath", new Object[0]));
        }
    }

    private static class ResizeKey {
        private final int[] hashes;

        private ResizeKey(AvatarType type, String id, int size) {
            this.hashes = new int[]{type.ordinal(), id.hashCode(), size};
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ResizeKey) {
                ResizeKey s = (ResizeKey)o;
                return Arrays.equals(this.hashes, s.hashes);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.hashes);
        }
    }

    private static class ResizeAvatarCallable
    implements Callable<Path> {
        private final I18nService i18nService;
        private final Path original;
        private final InputStream originalStream;
        private final int size;

        private ResizeAvatarCallable(I18nService i18nService, Path original, InputStream originalStream, int size) {
            this.i18nService = i18nService;
            this.original = original;
            this.originalStream = originalStream;
            this.size = size;
        }

        @Override
        public Path call() throws AvatarException {
            Path sized;
            block10: {
                Path path;
                block9: {
                    sized = this.original.resolveSibling(this.size + DiskAvatarRepository.FILE_EXTENSION);
                    InputStream ignored2 = Files.newInputStream(sized, new OpenOption[0]);
                    try {
                        path = sized;
                        if (ignored2 == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored2 != null) {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (FileNotFoundException | NoSuchFileException ignored2) {
                            break block10;
                        }
                        catch (IOException e) {
                            throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.unreadableimage", new Object[0]), (Throwable)e);
                        }
                    }
                    ignored2.close();
                }
                return path;
            }
            BufferedImage image = this.readOriginal();
            image = this.resize(image);
            this.writeResized(image, sized);
            return sized;
        }

        private BufferedImage readOriginal() {
            try {
                return ImageIO.read(this.originalStream);
            }
            catch (IOException e) {
                throw new AvatarLoadException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.unreadableimage", new Object[0]), (Throwable)e);
            }
        }

        private BufferedImage render(BufferedImage image, int width, int height, int type, Object hint) {
            BufferedImage tmp = new BufferedImage(width, height, type);
            Graphics2D graphics = tmp.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage(image, 0, 0, width, height, null);
            graphics.dispose();
            return tmp;
        }

        private BufferedImage resize(BufferedImage image) {
            int type;
            int n = type = image.getTransparency() == 1 ? 1 : 2;
            if (this.size > image.getHeight() || this.size > image.getWidth()) {
                image = this.render(image, this.size, this.size, type, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            } else {
                int height = image.getHeight();
                int width = image.getWidth();
                do {
                    height = this.sizeDown(height);
                    width = this.sizeDown(width);
                    image = this.render(image, width, height, type, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                } while (width != this.size || height != this.size);
            }
            return image;
        }

        private int sizeDown(int dimension) {
            if (dimension > this.size && (dimension /= 2) < this.size) {
                dimension = this.size;
            }
            return dimension;
        }

        private void writeResized(BufferedImage resized, Path target) {
            try (OutputStream outputStream = Files.newOutputStream(target, new OpenOption[0]);){
                ImageIO.write((RenderedImage)resized, DiskAvatarRepository.AVATAR_FORMAT, outputStream);
            }
            catch (IOException e) {
                throw new AvatarResizeException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.load.resizefailed", new Object[0]), (Throwable)e);
            }
        }
    }

    private static class LoadedAvatarSupplier
    extends AbstractAvatarSupplier
    implements CacheableAvatarSupplier {
        private final Path avatar;

        private LoadedAvatarSupplier(Path avatar) {
            super("image/png");
            this.avatar = avatar;
        }

        public long getTimestamp() {
            return MoreFiles.getLastModified((Path)this.avatar);
        }

        @Nonnull
        public InputStream open() throws IOException {
            return Files.newInputStream(this.avatar, new OpenOption[0]);
        }
    }
}

