/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.stash.internal.avatar.AvatarSource;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

@Component(value="urlAvatarSource")
public class UrlAvatarSource
implements AvatarSource {
    private final String defaultFallbackUrl;
    private final String httpUrlFormat;
    private final String httpsUrlFormat;

    @Autowired
    public UrlAvatarSource(@Value(value="${avatar.url.format.http}") String httpUrlFormat, @Value(value="${avatar.url.format.https}") String httpsUrlFormat, @Value(value="${avatar.url.default}") String defaultFallbackUrl) {
        this.defaultFallbackUrl = defaultFallbackUrl;
        this.httpUrlFormat = httpUrlFormat;
        this.httpsUrlFormat = httpsUrlFormat;
    }

    @Nonnull
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        Objects.requireNonNull(person, "person");
        String emailAddress = person.getEmailAddress();
        return this.getUrlForPerson(emailAddress, request);
    }

    private String encodeUrl(String url) {
        return UriUtils.encodeQueryParam((String)url, (Charset)StandardCharsets.UTF_8);
    }

    private String getUrlForPerson(String emailAddress, AvatarRequest request) {
        Objects.requireNonNull(request, "request");
        String hash = "00000000000000000000000000000000";
        if (StringUtils.isBlank((CharSequence)emailAddress)) {
            emailAddress = "";
        } else {
            hash = DigestUtils.md5Hex((String)emailAddress.toLowerCase(Locale.US));
        }
        String format = request.isSecure() ? this.httpsUrlFormat : this.httpUrlFormat;
        return String.format(format, hash, request.getSize(), this.encodeUrl(this.defaultFallbackUrl), emailAddress);
    }
}

