/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.AvatarUrlDecorator;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionAwareAvatarUrlDecorator
implements AvatarUrlDecorator {
    private static final String CACHE_NAME = VersionAwareAvatarUrlDecorator.class.getName();
    private final Cache<Integer, Long> projectSerialCache;
    private final Cache<Integer, Long> userSerialCache;

    @Autowired
    public VersionAwareAvatarUrlDecorator(AvatarRepository repository, CacheFactory cacheFactory) {
        CacheSettings settings = new CacheSettingsBuilder().expireAfterWrite(1L, TimeUnit.DAYS).replicateAsynchronously().replicateViaInvalidation().build();
        this.projectSerialCache = this.createSerialCache(repository, AvatarType.PROJECT, cacheFactory, settings);
        this.userSerialCache = this.createSerialCache(repository, AvatarType.USER, cacheFactory, settings);
    }

    public void decorate(@Nonnull NavBuilder.Builder<?> builder, @Nonnull ApplicationUser user) {
        this.decorateUrl(builder, this.userSerialCache, user.getId());
    }

    public void decorate(@Nonnull NavBuilder.Builder<?> builder, @Nonnull Project project) {
        this.decorateUrl(builder, this.projectSerialCache, project.getId());
    }

    public void invalidate(@Nonnull ApplicationUser user) {
        this.userSerialCache.remove((Object)user.getId());
    }

    public void invalidate(@Nonnull Project project) {
        this.projectSerialCache.remove((Object)project.getId());
    }

    private void decorateUrl(NavBuilder.Builder<?> builder, Cache<Integer, Long> cache, Integer id) {
        Long serial = (Long)cache.get((Object)id);
        if (serial != null) {
            builder.withParam("v", serial.toString());
        }
    }

    private Cache<Integer, Long> createSerialCache(final AvatarRepository repository, final AvatarType type, CacheFactory cacheFactory, CacheSettings settings) {
        return cacheFactory.getCache(CACHE_NAME + ".serial." + String.valueOf(type), (CacheLoader)new CacheLoader<Integer, Long>(){

            @Nonnull
            public Long load(@Nonnull Integer key) {
                return repository.getVersionId(type, key.intValue());
            }
        }, settings);
    }
}

