/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.stash.internal.avatar.FallbackAvatarSource;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="webResourceAvatarSource")
public class WebResourceAvatarSource
implements FallbackAvatarSource {
    public static final String AVATAR_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-webpack-INTERNAL:avatar";
    public static final String REVIEWER_GROUP_AVATAR_FORMAT = "avatar/group-avatar-%1$d.png";
    public static final String USER_AVATAR_FORMAT = "avatar/default-avatar-%1$d.png";
    private final WebResourceUrlProvider urlProvider;
    private final NavBuilder navBuilder;

    @Autowired
    public WebResourceAvatarSource(WebResourceUrlProvider urlProvider, NavBuilder navBuilder) {
        this.urlProvider = urlProvider;
        this.navBuilder = navBuilder;
    }

    @Nonnull
    public String getUrlForPerson(@Nonnull Person person, @Nonnull AvatarRequest request) {
        Objects.requireNonNull(person, "person");
        return this.formatUrl(request, USER_AVATAR_FORMAT);
    }

    @Nonnull
    public String getUrlForReviewerGroup(@Nonnull ReviewerGroup group, @Nonnull AvatarRequest request) {
        Objects.requireNonNull(group, "group");
        return this.formatUrl(request, REVIEWER_GROUP_AVATAR_FORMAT);
    }

    private static int normalizeSize(int size) {
        if (size > 192) {
            return 256;
        }
        if (size > 128) {
            return 192;
        }
        if (size > 96) {
            return 128;
        }
        if (size > 64) {
            return 96;
        }
        if (size > 48) {
            return 64;
        }
        if (size > 32) {
            return 48;
        }
        if (size > 24) {
            return 32;
        }
        if (size > 16) {
            return 24;
        }
        return 16;
    }

    private String formatUrl(AvatarRequest request, String format) {
        Objects.requireNonNull(request, "request");
        String resourceName = String.format(format, WebResourceAvatarSource.normalizeSize(request.getSize()));
        String avatarUrl = this.urlProvider.getStaticPluginResourceUrl(AVATAR_MODULE_KEY, resourceName, UrlMode.ABSOLUTE);
        if (request.isUseConfigured()) {
            avatarUrl = UrlUtils.replaceBaseUrlWithConfigured((NavBuilder)this.navBuilder, (String)avatarUrl);
        }
        return avatarUrl;
    }
}

