/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.MemberSelector;
import com.atlassian.nutcluster.core.MultiExecutionCallback;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.backup.Backup;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.backup.BackupFeature;
import com.atlassian.stash.internal.backup.BackupFeatureMode;
import com.atlassian.stash.internal.backup.BackupFeatures;
import com.atlassian.stash.internal.backup.BackupService;
import com.atlassian.stash.internal.backup.FileBackup;
import com.atlassian.stash.internal.backup.SimpleBackupFeature;
import com.atlassian.stash.internal.backup.liquibase.LiquibaseDao;
import com.atlassian.stash.internal.maintenance.BaseMaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.MaintenanceCompletionCallback;
import com.atlassian.stash.internal.maintenance.MaintenanceService;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskMonitor;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.maintenance.backup.AbstractBackupTask;
import com.atlassian.stash.internal.maintenance.backup.BackupClientProgressCallback;
import com.atlassian.stash.internal.maintenance.latch.ResultCollectingExecutionCallback;
import com.atlassian.stash.internal.nutcluster.NodeIdMemberSelector;
import com.atlassian.stash.internal.server.DataStoreDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="backupService")
public class DefaultBackupService
implements BackupService {
    private static final String CLIENT_PROGRESS_TIMEOUT_PROP = "${maintenance.backup.client-progress.timeout}";
    private static final String EXTENSION_ZIP = ".zip";
    private static final int LENGTH_SUFFIX = (new SimpleDateFormat("yyyyMMdd-HHmmss-SSS'Z'").format(new Date()) + ".zip").length();
    private static final int LENGTH_EXTENSION = ".zip".length();
    private static final Pattern PATTERN_UTC_FILE_NAME = Pattern.compile("backup-[^\\\\/.]+-([0-9]{8}-[0-9]{6}-[0-9]{3})Z\\.zip");
    private static final Comparator<Path> FILE_NAME_TIMESTAMP_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path left, Path right) {
            return this.fileNameTimestamp(right).compareTo(this.fileNameTimestamp(left));
        }

        private String fileNameTimestamp(Path file) {
            String filename = file.getFileName().toString();
            int length = filename.length();
            return filename.substring(length - LENGTH_SUFFIX, length - LENGTH_EXTENSION);
        }
    };
    private static final Function<Class<?>, BackupFeature> CLASS_TO_BACKUP_FEATURE = clazz -> new SimpleBackupFeature("database", clazz.getSimpleName(), BackupFeatureMode.RESTORE);
    private static final Logger log = LoggerFactory.getLogger(DefaultBackupService.class);
    private final Duration clientProgressTimeout;
    private final IExecutorService clusterExecutorService;
    private final Supplier<ClusterProgressCallback> clusterProgressCallbackProvider;
    private final DataStoreDao dataStoreDao;
    private final DmzMeshService dmzMeshService;
    private final HomeLayout homeLayout;
    private final I18nService i18nService;
    private final LiquibaseDao liquibaseDao;
    private final MaintenanceService maintenanceService;
    private final MaintenanceTaskFactory maintenanceTaskFactory;
    private volatile BackupClientProgressCallback localClientProgressCallback;

    @Autowired
    public DefaultBackupService(@DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${maintenance.backup.client-progress.timeout}") Duration clientProgressTimeout, IExecutorService clusterExecutorService, DataStoreDao dataStoreDao, DmzMeshService dmzMeshService, HomeLayout homeLayout, I18nService i18nService, LiquibaseDao liquibaseDao, MaintenanceService maintenanceService, MaintenanceTaskFactory maintenanceTaskFactory) {
        this(clientProgressTimeout, clusterExecutorService, ClusterProgressCallback::new, dataStoreDao, dmzMeshService, homeLayout, i18nService, liquibaseDao, maintenanceService, maintenanceTaskFactory);
    }

    @VisibleForTesting
    DefaultBackupService(Duration clientProgressTimeout, IExecutorService clusterExecutorService, Supplier<ClusterProgressCallback> clusterProgressCallbackProvider, DataStoreDao dataStoreDao, DmzMeshService dmzMeshService, HomeLayout homeLayout, I18nService i18nService, LiquibaseDao liquibaseDao, MaintenanceService maintenanceService, MaintenanceTaskFactory maintenanceTaskFactory) {
        this.clientProgressTimeout = clientProgressTimeout;
        this.clusterExecutorService = clusterExecutorService;
        this.clusterProgressCallbackProvider = clusterProgressCallbackProvider;
        this.dataStoreDao = dataStoreDao;
        this.dmzMeshService = dmzMeshService;
        this.homeLayout = homeLayout;
        this.i18nService = i18nService;
        this.liquibaseDao = liquibaseDao;
        this.maintenanceService = maintenanceService;
        this.maintenanceTaskFactory = maintenanceTaskFactory;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MaintenanceTaskMonitor backup() {
        return this.submitBackupTask(this.maintenanceTaskFactory.backupTask());
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public MaintenanceTaskMonitor externalBackup() {
        return this.submitBackupTask(this.maintenanceTaskFactory.externalBackupTask());
    }

    private MaintenanceTaskMonitor submitBackupTask(AbstractBackupTask backupTask) {
        try {
            MaintenanceTaskMonitor taskMonitor = this.maintenanceService.start((MaintenanceTask)backupTask, MaintenanceType.BACKUP);
            this.localClientProgressCallback = backupTask.getClientProgressCallback();
            taskMonitor.registerCallback((MaintenanceCompletionCallback)new BaseMaintenanceCompletionCallback(){

                @Override
                protected void onCompletion() {
                    DefaultBackupService.this.localClientProgressCallback = null;
                }
            });
            return taskMonitor;
        }
        catch (IllegalStateException e) {
            log.error("An attempt to start a backup was blocked because maintenance is already in progress");
            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.already.running", new Object[0]));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public boolean delete(@Nonnull Backup backup) {
        String name = this.validateName(Objects.requireNonNull(backup, "backup").getName());
        Path file = this.homeLayout.getBackupDir().resolve(name);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Files.delete(file);
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Page<Backup> findAll(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        List<Path> files = this.listBackupFiles();
        if (pageRequest.getStart() > files.size()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        List<Path> page = pageRequest.getStart() > 0 ? files.subList(pageRequest.getStart(), files.size()) : files;
        return PageUtils.createPage(page, (PageRequest)pageRequest).transform(FileBackup::new);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Backup findByName(@Nonnull String name) {
        name = this.validateName(name);
        Path backup = this.homeLayout.getBackupDir().resolve(name);
        if (Files.isRegularFile(backup, new LinkOption[0])) {
            return new FileBackup(backup);
        }
        return null;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Backup getByName(@Nonnull String name) {
        Backup backup = this.findByName(name);
        if (backup == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.backup.nosuchbackup", new Object[]{name}));
        }
        return backup;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Backup getLatest() {
        List<Path> files = this.listBackupFiles();
        if (files.isEmpty()) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.backup.nobackups", new Object[0]));
        }
        return new FileBackup(files.get(0));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public List<BackupFeature> getFeatures() {
        boolean hasRemoteMeshNodes;
        ImmutableList.Builder features = ImmutableList.builder();
        features.addAll(BackupFeatures.getFeatures());
        this.liquibaseDao.findCustomChanges().stream().map(CLASS_TO_BACKUP_FEATURE).forEach(arg_0 -> ((ImmutableList.Builder)features).add(arg_0));
        if (this.dataStoreDao.countAll() > 0L) {
            features.add((Object)BackupFeatures.DATA_STORES);
        }
        if (hasRemoteMeshNodes = this.dmzMeshService.getMembers().stream().anyMatch(node -> !node.isSidecar())) {
            features.add((Object)BackupFeatures.MESH);
        }
        return features.build();
    }

    @Unsecured(value="Updating the client's backup progress cannot be secured; the database may not be available")
    public void updateClientProgress(int percentage) {
        block6: {
            Preconditions.checkArgument((percentage >= 0 && percentage <= 100 ? 1 : 0) != 0, (Object)"Progress must be between 0 and 100");
            BackupClientProgressCallback listener = this.localClientProgressCallback;
            if (listener != null) {
                listener.onProgressUpdate(percentage);
            } else {
                MaintenanceTaskMonitor task = this.maintenanceService.getRunningTask();
                if (task != null && task.getType() == MaintenanceType.BACKUP) {
                    ClusterProgressCallback callback = this.clusterProgressCallbackProvider.get();
                    this.clusterExecutorService.submitToMembers((Callable)new UpdateClientProgress(percentage), (MemberSelector)new NodeIdMemberSelector(task.getOwnerNodeId()), (MultiExecutionCallback)callback);
                    try {
                        if (!callback.await(this.clientProgressTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                            throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.client.progress.failed", new Object[0]));
                        }
                        break block6;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new BackupException(this.i18nService.createKeyedMessage("bitbucket.backup.client.progress.failed", new Object[0]), (Throwable)e);
                    }
                }
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.backup.not.backing.up", new Object[0]));
            }
        }
    }

    private List<Path> listBackupFiles() {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.list(this.homeLayout.getBackupDir());
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> PATTERN_UTC_FILE_NAME.matcher(path.getFileName().toString()).matches()).sorted(FILE_NAME_TIMESTAMP_COMPARATOR).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    private String validateName(String name) {
        Objects.requireNonNull(name, "name");
        name = name.trim();
        if (!PATTERN_UTC_FILE_NAME.matcher(name).matches()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.backup.invalidname", new Object[]{name}));
        }
        return name;
    }

    @VisibleForTesting
    static class ClusterProgressCallback
    extends ResultCollectingExecutionCallback<Void> {
        ClusterProgressCallback() {
        }
    }

    @SpringAware
    @VisibleForTesting
    static class UpdateClientProgress
    implements Serializable,
    Callable<Void> {
        private static final long serialVersionUID = 1L;
        private final int progress;
        private volatile BackupService backupService;

        private UpdateClientProgress(int progress) {
            this.progress = progress;
        }

        @Override
        public Void call() {
            Preconditions.checkState((this.backupService != null ? 1 : 0) != 0, (Object)"BackupService hasn't been injected");
            this.backupService.updateClientProgress(this.progress);
            return null;
        }

        @Autowired
        public void setBackupService(BackupService backupService) {
            this.backupService = backupService;
        }
    }
}

