/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.backup.Backup;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class FileBackup
implements Backup {
    private final Path file;

    public FileBackup(@Nonnull Path file) {
        this.file = Objects.requireNonNull(file, "file");
    }

    public long getModified() {
        return MoreFiles.getLastModified((Path)this.file);
    }

    @Nonnull
    public String getName() {
        return this.file.getFileName().toString();
    }

    public long getSize() {
        return MoreFiles.size((Path)this.file);
    }

    @Nonnull
    public InputStream getInput() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }
}

