/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.banner;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBanner;
import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBannerAudience;
import com.atlassian.bitbucket.dmz.admin.banner.DmzAnnouncementBannerService;
import com.atlassian.bitbucket.dmz.admin.banner.SetAnnouncementBannerRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.banner.AnnouncementBannerDao;
import com.atlassian.stash.internal.banner.InternalAnnouncementBanner;
import com.atlassian.stash.internal.banner.event.AnnouncementBannerDeletedEvent;
import com.atlassian.stash.internal.banner.event.AnnouncementBannerSetEvent;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzAnnouncementBannerService.class)
@Service(value="announcementBannerService")
public class DefaultAnnouncementBannerService
extends AbstractService
implements DmzAnnouncementBannerService {
    private final AuthenticationContext authenticationContext;
    private final AnnouncementBannerDao dao;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultAnnouncementBannerService(@Nonnull AuthenticationContext authenticationContext, @Nonnull AnnouncementBannerDao dao, @Nonnull EventPublisher eventPublisher) {
        this.authenticationContext = authenticationContext;
        this.dao = dao;
        this.eventPublisher = eventPublisher;
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void deleteBanner() {
        InternalAnnouncementBanner banner = this.getConfiguredBanner().map(b -> new InternalAnnouncementBanner.Builder(b).build()).orElse(null);
        this.dao.deleteById((Object)1L);
        if (banner != null) {
            this.eventPublisher.publish((Object)new AnnouncementBannerDeletedEvent(this, (AnnouncementBanner)banner));
        }
    }

    @Nonnull
    public Optional<AnnouncementBanner> getActiveBanner() {
        AnnouncementBannerAudience audience = this.authenticationContext.isAuthenticated() ? AnnouncementBannerAudience.AUTHENTICATED : AnnouncementBannerAudience.ALL;
        return Optional.ofNullable(this.dao.findEnabledByAudience(audience));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public Optional<AnnouncementBanner> getConfiguredBanner() {
        return Optional.ofNullable((AnnouncementBanner)this.dao.getById((Object)1L));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setBanner(@Nonnull SetAnnouncementBannerRequest bannerRequest) {
        Objects.requireNonNull(bannerRequest, "bannerRequest");
        InternalAnnouncementBanner newBanner = new InternalAnnouncementBanner.Builder(bannerRequest).build();
        InternalAnnouncementBanner previousBanner = this.getConfiguredBanner().map(b -> new InternalAnnouncementBanner.Builder(b).build()).orElse(null);
        this.dao.update((Object)newBanner);
        this.eventPublisher.publish((Object)new AnnouncementBannerSetEvent(this, (AnnouncementBanner)newBanner, (AnnouncementBanner)previousBanner));
    }
}

