/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.banner.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBanner;
import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBannerAudience;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

@AsynchronousPreferred
@EventName(value="stash.announcement-banner.set")
@TransactionAware
public class AnnouncementBannerSetEvent
extends ApplicationEvent {
    private final AnnouncementBanner announcementBanner;
    private final AnnouncementBanner previousBanner;

    public AnnouncementBannerSetEvent(@Nonnull Object source, @Nonnull AnnouncementBanner announcementBanner, @Nullable AnnouncementBanner previousBanner) {
        super(source);
        this.announcementBanner = Objects.requireNonNull(announcementBanner, "announcementBanner");
        this.previousBanner = previousBanner;
    }

    @Nonnull
    public AnnouncementBanner getAnnouncementBanner() {
        return this.announcementBanner;
    }

    public AnnouncementBannerAudience getAudience() {
        return this.announcementBanner.getAudience();
    }

    public Optional<AnnouncementBanner> getPreviousBanner() {
        return Optional.ofNullable(this.previousBanner);
    }

    public boolean isEnabled() {
        return this.announcementBanner.isEnabled();
    }
}

