/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.batch;

import com.atlassian.stash.internal.util.TransactionBatcher;
import com.google.common.collect.Iterators;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.OptimisticLockException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.BaseStream;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class BatchingStreamProcessor<I, S extends BaseStream<I, S>, E> {
    private static final Logger log = LoggerFactory.getLogger(BatchingStreamProcessor.class);
    private final int fetchSize;
    private final PlatformTransactionManager transactionManager;
    private final int updateAttempts;

    public BatchingStreamProcessor(@Nonnull PlatformTransactionManager transactionManager, int fetchSize, int updateAttempts) {
        this.transactionManager = transactionManager;
        this.fetchSize = fetchSize;
        this.updateAttempts = updateAttempts;
    }

    public void process(@Nonnull S idStream) {
        try (S stream = idStream;){
            TransactionBatcher txBatcher = new TransactionBatcher(this.transactionManager, Integer.MAX_VALUE, "batch update");
            Iterators.partition(stream.iterator(), (int)this.fetchSize).forEachRemaining(batch -> this.onOptimisticLockExceptionRetry(() -> {
                txBatcher.start();
                List<E> entities = this.loadBatch((List<I>)batch);
                for (E entity : entities) {
                    this.onEntity(entity);
                }
                txBatcher.commit();
            }, txBatcher::rollback));
        }
    }

    protected abstract void onEntity(@Nonnull E var1);

    @Nonnull
    protected abstract List<? extends E> loadBatch(@Nonnull List<I> var1);

    @Nullable
    private Serializable maybeGetEntityIdentifier(@Nonnull Exception e) {
        if (e instanceof StaleObjectStateException) {
            return ((StaleObjectStateException)e).getIdentifier();
        }
        if (e instanceof OptimisticLockException && ((OptimisticLockException)e).getEntity() != null) {
            return String.valueOf(((OptimisticLockException)e).getEntity());
        }
        if (e instanceof ObjectOptimisticLockingFailureException && ((ObjectOptimisticLockingFailureException)e).getIdentifier() != null) {
            return String.valueOf(((ObjectOptimisticLockingFailureException)e).getIdentifier());
        }
        return null;
    }

    private void onOptimisticLockExceptionRetry(@Nonnull Runnable attempt, @Nonnull Runnable onRetry) {
        Throwable optimisticLockException = null;
        for (int attemptNo = 1; attemptNo <= this.updateAttempts; ++attemptNo) {
            try {
                attempt.run();
                optimisticLockException = null;
                break;
            }
            catch (OptimisticLockException | StaleStateException | ObjectOptimisticLockingFailureException e) {
                Serializable identifier = this.maybeGetEntityIdentifier((Exception)e);
                if (identifier != null) {
                    log.debug("Batch update: Entity '{}' was out of date. Retrying whole batch... ({}/{})", new Object[]{identifier, attemptNo, this.updateAttempts, log.isTraceEnabled() ? e : null});
                } else {
                    log.debug("Batch update: Entity was out of date. Retrying whole batch... ({}/{})", new Object[]{attemptNo, this.updateAttempts, log.isTraceEnabled() ? e : null});
                }
                optimisticLockException = e;
                onRetry.run();
                continue;
            }
        }
        if (optimisticLockException != null) {
            throw optimisticLockException;
        }
    }
}

