/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAlreadyExistsException;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.PermissionException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.RemoveSetupConfigurationRequest;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.InternalLicenseService;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.profiles.Production;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Production
@Component(value="bootstrapOperation")
public class BootstrapOperation
implements UncheckedOperation<Void> {
    @VisibleForTesting
    static final String KEY_MIRROR_UPSTREAM = "plugin.mirroring.upstream.url";
    @VisibleForTesting
    static final String KEY_MIRROR_TYPE = "plugin.mirroring.upstream.type";
    @VisibleForTesting
    static final String VALUE_CLOUD_MIRROR = "cloud";
    @VisibleForTesting
    static final String VALUE_SERVER_MIRROR = "server";
    static final String LICENSE_MIRROR = "AAABtQ0ODAoPeNp9klGLm0AUhd/zKy70LWBi3NK0AaFZtSU0xtSYhdL2YTLerNPoTJi5Zpt/34mOkIWlIAh\nzzxy/c4/viqqFlGmYfQQ/WDx8Wryfw9e0gMAPZqNISWKcNqzBkJ8Ur9TFnMTIEDPVZC04SoPF9Y\nydIMrSNMmj1XLtBCkTklAyyTH5exb6GjPCMPD9mdc9g31ihfW9/w71BfUqDh+/BZn3MN9894L1N\nveePsyXzjvTz0wKw0goGS6pZsYIJmFLV1hT6UQxGq7FudN0BFhC3VPDUWlo7ftwhUZorbRxl7at\n5hUzOMD6DrafRhq7b749dSt5O+14PN5khfcly71tnsX7qFhlG2+/S+wg7HwtnsWhCsEZQSK5KlH\nDWas/yAl+VkTnX4vp9FlN2JB6wlUzdbk87G/8nkCsQCqCUhjS4tASWmdhgBTw1pBqUJvJkOqu51\nTY+FjDjtqyYdIp7FRcMCTd4i1IlCfLIom9xx83+LvqHLjtbi9PUr3I0f83tmmbA+rsuDcWJxxOk\nwur277bI6sNjly6Jyu6HQavufsfqDE98edXixlaZZok6i7h6B8afQJ3MC0CFQCLM5CPzVszpZik\nP0UoAPVc0BkZeQIURwXbDBonG6/PSn2XY23ZXxAHYYk=X02l1";
    private static final Logger log = LoggerFactory.getLogger(BootstrapOperation.class);
    private static final String[] MIRROR_FARM_REQUIRED_PROPERTIES = new String[]{"plugin.mirroring.upstream.type", "plugin.mirroring.upstream.url", "setup.baseUrl", "setup.displayName"};
    protected final DirectoryManager directoryManager;
    protected final InternalApplicationPropertiesService propertiesService;
    protected final LicenseHelper licenseHelper;
    protected final InternalLicenseService licenseService;
    protected final ApplicationMode applicationMode;
    private final ApplicationManager appManager;
    private final ClusterService clusterService;
    private final EventPublisher eventPublisher;
    private final ConfigurationService configurationService;
    private final GlobalPermissionDao globalPermissionDao;
    private final ApplicationPropertyDao applicationPropertyDao;
    private final ApplicationUserDao userDao;

    @Autowired
    public BootstrapOperation(DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, ApplicationUserDao userDao, ApplicationManager appManager, LicenseHelper licenseHelper, ConfigurationService configurationService, GlobalPermissionDao globalPermissionDao, ApplicationPropertyDao applicationPropertyDao, InternalLicenseService licenseService, ClusterService clusterService, EventPublisher eventPublisher) {
        this.directoryManager = directoryManager;
        this.propertiesService = propertiesService;
        this.userDao = userDao;
        this.appManager = appManager;
        this.licenseHelper = licenseHelper;
        this.configurationService = configurationService;
        this.globalPermissionDao = globalPermissionDao;
        this.applicationPropertyDao = applicationPropertyDao;
        this.licenseService = licenseService;
        this.applicationMode = propertiesService.getMode();
        this.clusterService = clusterService;
        this.eventPublisher = eventPublisher;
    }

    @Transactional
    public Void perform() {
        Application application = this.createApplication();
        Directory directory = this.createDirectory(application);
        this.addDefaultGroup(directory);
        RemoveSetupConfigurationRequest.Builder setupConfigurationBuilder = new RemoveSetupConfigurationRequest.Builder();
        boolean isSetup = this.setupLicense(setupConfigurationBuilder);
        if (isSetup) {
            isSetup = this.setupUsers(setupConfigurationBuilder, directory);
        }
        isSetup &= this.setupBaseUrl(setupConfigurationBuilder);
        isSetup &= this.setupDisplayName(setupConfigurationBuilder);
        if (this.applicationMode == ApplicationMode.MIRROR) {
            String type = StringUtils.stripToNull((String)this.propertiesService.getProperty(KEY_MIRROR_TYPE, VALUE_SERVER_MIRROR));
            isSetup = VALUE_SERVER_MIRROR.equalsIgnoreCase(type) ? (isSetup &= StringUtils.isNotBlank((CharSequence)this.propertiesService.getProperty(KEY_MIRROR_UPSTREAM))) : (isSetup &= VALUE_CLOUD_MIRROR.equalsIgnoreCase(type));
            if (!isSetup && this.clusterService.getInformation().isNetworkingEnabled()) {
                this.johnsonWithRequiredMirrorFarmProperties();
            }
        }
        if (isSetup) {
            this.propertiesService.setSetup(true);
            log.info("Application setup completed successfully");
        }
        if (setupConfigurationBuilder.hasPropertiesToRemove()) {
            this.configurationService.removeSetupProperties(setupConfigurationBuilder.build());
        }
        return null;
    }

    protected boolean setupLicense(RemoveSetupConfigurationRequest.Builder builder) {
        ApplicationProperty currentLicenseProperty = this.applicationPropertyDao.getById(ApplicationProperty.Key.LICENSE);
        String currentLicense = currentLicenseProperty == null ? null : currentLicenseProperty.getValue();
        String setupLicense = this.propertiesService.getProperty("setup.license");
        if (StringUtils.isNotBlank((CharSequence)currentLicense)) {
            if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
                log.warn("Found {} property in {}, but ignored it because it's already set up", (Object)"setup.license", (Object)"bitbucket.properties");
            }
            return true;
        }
        if (this.applicationMode == ApplicationMode.MIRROR) {
            if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
                log.warn("Found {} property in {}, but ignored it because this is a mirror", (Object)"setup.license", (Object)"bitbucket.properties");
            }
            this.licenseService.setUnvalidated(LICENSE_MIRROR);
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)setupLicense)) {
            DualLicense dualLicense;
            log.info("Found {} property in {}", (Object)"setup.license", (Object)"bitbucket.properties");
            try {
                dualLicense = this.licenseHelper.decode(setupLicense);
            }
            catch (IllegalArgumentException iae) {
                dualLicense = null;
            }
            if (dualLicense == null) {
                log.error("Property {} in {} is not valid", (Object)"setup.license", (Object)"bitbucket.properties");
                return false;
            }
            this.licenseHelper.set(setupLicense);
            builder.removeLicense();
            return true;
        }
        return false;
    }

    protected boolean setupBaseUrl(RemoveSetupConfigurationRequest.Builder builder) {
        URI baseUrl = this.propertiesService.getBaseUrl();
        String baseUrlString = this.propertiesService.getProperty("setup.baseUrl");
        if (baseUrl != null) {
            if (StringUtils.isNotBlank((CharSequence)baseUrlString)) {
                log.warn("Found {} property in {}, but ignored it because it's already set up", (Object)"setup.baseUrl", (Object)"bitbucket.properties");
            }
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)baseUrlString)) {
            log.info("Found {} property in {}", (Object)"setup.baseUrl", (Object)"bitbucket.properties");
            try {
                this.propertiesService.setBaseURL(new URI(baseUrlString));
            }
            catch (URISyntaxException e) {
                log.error("Property {} in {} is not valid: {}", new Object[]{"setup.baseUrl", "bitbucket.properties", e.getMessage()});
                return false;
            }
            builder.removeBaseUrl();
            return true;
        }
        return false;
    }

    protected boolean setupUsers(RemoveSetupConfigurationRequest.Builder builder, Directory directory) {
        try {
            boolean someAdminPropsSupplied;
            Set<String> missingAdminProps = this.findMissingAdminProps();
            boolean someAdminPropsMissing = missingAdminProps.size() > 0;
            boolean bl = someAdminPropsSupplied = missingAdminProps.size() < ApplicationConstants.SETUP_USER_PROPERTIES.size();
            if (this.applicationMode == ApplicationMode.MIRROR) {
                if (someAdminPropsSupplied) {
                    log.warn("Found sysadmin user properties in {}, but ignored them because this is a mirror and cannot manage local users", (Object)"bitbucket.properties");
                }
                return true;
            }
            if (this.usersExist()) {
                if (someAdminPropsSupplied) {
                    log.warn("Found sysadmin user properties in {}, but ignored them because user(s) already exist", (Object)"bitbucket.properties");
                }
                return true;
            }
            if (someAdminPropsMissing) {
                if (someAdminPropsSupplied) {
                    log.error("Aborting the creation of the initial sysadmin user: not all the needed properties are available in {}. Missing keys: {}", (Object)"bitbucket.properties", (Object)missingAdminProps.toString());
                }
                return false;
            }
            log.info("Creating initial sysadmin user...");
            this.createUser(directory, this.propertiesService.getProperty("setup.sysadmin.username"), this.propertiesService.getProperty("setup.sysadmin.password"), this.propertiesService.getProperty("setup.sysadmin.displayName"), this.propertiesService.getProperty("setup.sysadmin.emailAddress"), true, true);
            log.info("Created the initial sysadmin, user name: {}", (Object)this.propertiesService.getProperty("setup.sysadmin.username"));
            builder.removeSysAdmin();
            return true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void createUser(Directory directory, String username, String password, String displayName, String emailAddress, boolean addToDefaultGroup, boolean isSysAdmin) throws Exception {
        UserTemplate userTemplate = new UserTemplate(username, username, username, displayName);
        userTemplate.setDirectoryId(directory.getId().longValue());
        userTemplate.setEmailAddress(emailAddress);
        userTemplate.setActive(true);
        this.directoryManager.addUser(directory.getId().longValue(), UserTemplateWithAttributes.toUserWithNoAttributes((User)userTemplate), new PasswordCredential(password));
        if (addToDefaultGroup) {
            this.directoryManager.addUserToGroup(directory.getId().longValue(), username, "stash-users");
        }
        if (isSysAdmin) {
            InternalNormalUser user = this.userDao.findByName(username);
            this.globalPermissionDao.create((Object)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().permission(Permission.SYS_ADMIN)).user((InternalApplicationUser)user)).build());
        }
    }

    protected boolean usersExist() {
        return this.userDao.findAll(PageUtils.newRequest((int)0, (int)1)).getSize() > 0;
    }

    private void addDefaultGroup(Directory directory) {
        Long directoryId = directory.getId();
        try {
            this.directoryManager.findGroupByName(directoryId.longValue(), "stash-users");
        }
        catch (GroupNotFoundException gnfe) {
            try {
                log.debug("Add group");
                this.directoryManager.addGroup(directoryId.longValue(), new GroupTemplate("stash-users", directoryId.longValue()));
                this.globalPermissionDao.create((Object)((InternalGlobalPermission.Builder)((InternalGlobalPermission.Builder)new InternalGlobalPermission.Builder().group("stash-users")).permission(Permission.LICENSED_USER)).build());
                log.info("Group added");
            }
            catch (CrowdException | PermissionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Directory createDirectory(Application application) {
        Directory directory;
        try {
            directory = this.directoryManager.findDirectoryByName(ApplicationConstants.INTERNAL_DIRECTORY_NAME);
        }
        catch (DirectoryNotFoundException e) {
            log.debug("Create directory");
            DirectoryImpl newDirectory = this.createDirectory(ApplicationConstants.INTERNAL_DIRECTORY_NAME, ApplicationConstants.INTERNAL_DIRECTORY_NAME, DirectoryType.INTERNAL, InternalDirectory.class, OperationType.values(), (Map<String, String>)ImmutableMap.of((Object)"user_encryption_method", (Object)"atlassian-security"));
            log.info("Directory created");
            try {
                directory = this.directoryManager.addDirectory((Directory)newDirectory);
            }
            catch (DirectoryInstantiationException die) {
                throw Throwables.propagate((Throwable)die);
            }
        }
        try {
            this.appManager.addDirectoryMapping(application, directory, true, OperationType.values());
        }
        catch (CrowdException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return directory;
    }

    private Application createApplication() {
        try {
            return this.appManager.findByName("crowd-embedded");
        }
        catch (ApplicationNotFoundException e) {
            log.debug("Create application");
            ApplicationImpl newApplication = this.createApplication("crowd-embedded", ApplicationType.CROWD, PasswordCredential.NONE);
            newApplication.setMembershipAggregationEnabled(true);
            log.info("Application created");
            try {
                return this.appManager.add((Application)newApplication);
            }
            catch (ApplicationAlreadyExistsException | InvalidCredentialException exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        }
    }

    private boolean setupDisplayName(RemoveSetupConfigurationRequest.Builder setupConfigurationBuilder) {
        String displayName = this.propertiesService.getDisplayName();
        String displayNameConfig = this.propertiesService.getProperty("setup.displayName");
        if (StringUtils.isBlank((CharSequence)displayName)) {
            if (StringUtils.isBlank((CharSequence)displayNameConfig)) {
                if (this.applicationMode == ApplicationMode.MIRROR) {
                    return false;
                }
                this.propertiesService.setDisplayName(ApplicationConstants.PRODUCT_NAME);
            } else {
                log.info("Found {} property in {}", (Object)"setup.displayName", (Object)"bitbucket.properties");
                this.propertiesService.setDisplayName(displayNameConfig);
                setupConfigurationBuilder.removeDisplayName();
            }
        } else if (StringUtils.isNotBlank((CharSequence)displayNameConfig)) {
            log.warn("Found {} property in {}, but ignored it because it's already set up", (Object)"setup.displayName", (Object)"bitbucket.properties");
        }
        return true;
    }

    private void johnsonWithRequiredMirrorFarmProperties() {
        List missingProperties = (List)Stream.of(MIRROR_FARM_REQUIRED_PROPERTIES).filter(prop -> StringUtils.stripToNull((String)this.propertiesService.getProperty(prop)) == null).collect(MoreCollectors.toImmutableList());
        String messageStart = "The mirror node is missing configuration properties for clustered operation.\n\tPlease ensure the following properties are set in bitbucket.properties:\n";
        String message = messageStart + missingProperties.stream().collect(Collectors.joining("</li><li>", "<ul><li>", "</li></ul>"));
        Event johnsonEvent = new Event(EventType.get((String)"mirror-configuration-missing"), message, EventLevel.get((String)"error"));
        this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        log.error(messageStart + missingProperties.stream().map(prop -> "\t - " + prop).collect(Collectors.joining("\n")));
        throw new IllegalArgumentException(messageStart + String.join((CharSequence)"\t\n", missingProperties));
    }

    private Set<String> findMissingAdminProps() {
        HashSet missingProperties = Sets.newHashSet();
        for (String propertyName : ApplicationConstants.SETUP_USER_PROPERTIES) {
            this.checkAndAdd(propertyName, missingProperties);
        }
        return missingProperties;
    }

    private void checkAndAdd(String property, Set<String> missingProperties) {
        if (StringUtils.isBlank((CharSequence)this.propertiesService.getProperty(property))) {
            missingProperties.add(property);
        }
    }

    private DirectoryImpl createDirectory(String name, String description, DirectoryType type, Class implementationClass, OperationType[] operations, Map<String, String> attributes) {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setName(name);
        directory.setActive(true);
        directory.setDescription(description);
        directory.setType(type);
        directory.setImplementationClass(implementationClass.getName());
        for (OperationType operationType : operations) {
            directory.addAllowedOperation(operationType);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            directory.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return directory;
    }

    private ApplicationImpl createApplication(String name, ApplicationType type, PasswordCredential credential) {
        return ApplicationImpl.newInstanceWithCredential((String)name, (ApplicationType)type, (PasswordCredential)credential);
    }
}

