/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.bootstrap.BootstrapOperation;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.RemoveSetupConfigurationRequest;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.InternalLicenseService;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.profiles.Dev;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.ApplicationUserDao;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Dev
@Component(value="bootstrapOperation")
public class DevBootstrapOperation
extends BootstrapOperation {
    public static final String LICENSE_CLUSTERED = "AAABmg0ODAoPeNp9Ul1v0zAUfc+vsMRbJadJtjGpUiS2JJRONOlaB4SAB9e9W0xTu7JvCv33eImDOoR4vefe\n4/PhN59hR5bckPiWRNezKJ5FCZkvGUmiJA4yrZALLPkBUrHXotEnu5eBRW6b8KMUoCyw8xH6BVZs\n2KKce3TJpUJQXAkofh2lOeccIV1dfRhJC7fRXrJuwJzALPL0/qF+pI9XGaPz+uGGspvbkdRx8Awc\nr0nRdOCnlXnmSlqOUqv0DltureTKg6vOiIZb6J9PoviaRm9pHHs0M9Cf/Rv1Dv/SP5lMyorR99Wa\nrtZVXmdsUZW03hQOSHtCF+n2TLAB4hlIoYTegSFHo3+AQPK1QTx+m02nzzrko+JQ6MO0HS4oDBff\nQ5JrojSSnbRo5LZDcMzSEtREdBb1AYwNRzsXff0JgjCwLjG/4mB5giE+JzhbF3esyOn9lxf1F214\n5a6OWu2V/qmC/2dVdoctmOqptk5PGid+XJx42w3NPPHWQuD9fXJbL8PktfLhU2Av+N2rYMY6uUEF\npncY/AYCgfFAMCwCFHzkBlkGH/vRdTeeBSfUMzUDb4W2AhQyM893WPg2Q8oQAYRdBSyKeVUdog==\nX02jr";
    private static final Logger log = LoggerFactory.getLogger(DevBootstrapOperation.class);
    private static final List<UserData> ADMINISTRATORS = ImmutableList.of((Object)new UserData("admin", "Administrator", "admin@example.com"));
    private static final List<UserData> USERS = ImmutableList.of((Object)new UserData("user", "User", "user@example.com"));

    @Autowired
    public DevBootstrapOperation(DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, ApplicationUserDao userDao, ApplicationManager appManager, LicenseHelper licenseHelper, ConfigurationService configurationService, GlobalPermissionDao globalPermissionDao, ApplicationPropertyDao applicationPropertyDao, InternalLicenseService licenseService, ClusterService clusterService, EventPublisher eventPublisher) {
        super(directoryManager, propertiesService, userDao, appManager, licenseHelper, configurationService, globalPermissionDao, applicationPropertyDao, licenseService, clusterService, eventPublisher);
    }

    @Override
    protected boolean setupLicense(RemoveSetupConfigurationRequest.Builder builder) {
        if (super.setupLicense(builder)) {
            return true;
        }
        this.licenseService.set(LICENSE_CLUSTERED, false);
        return true;
    }

    @Override
    protected boolean setupBaseUrl(RemoveSetupConfigurationRequest.Builder builder) {
        if (super.setupBaseUrl(builder)) {
            return true;
        }
        this.propertiesService.setBaseURL(UrlUtils.uncheckedCreateURI((String)String.format("http://%s:7990/bitbucket", this.getBaseUrlMachineName())));
        return true;
    }

    @Override
    protected boolean setupUsers(RemoveSetupConfigurationRequest.Builder builder, Directory directory) {
        try {
            boolean isMirror = this.applicationMode == ApplicationMode.MIRROR;
            DualLicense license = this.licenseHelper.getDecoded();
            if (license == null) {
                throw new IllegalStateException("A license must be set prior to adding dev mode users");
            }
            int licensedUsers = 0;
            if (this.usersExist()) {
                log.info("Skipping user creation on setup: users have already been created");
                return true;
            }
            for (UserData admin : ADMINISTRATORS) {
                this.createUser(directory, admin.username, admin.username, admin.displayName, admin.emailAddress, true, true);
                log.info("Created administrator '{}'", (Object)admin.username);
                ++licensedUsers;
            }
            if (!isMirror) {
                for (UserData data : USERS) {
                    boolean willExceedLicense = licensedUsers >= license.getMaximumNumberOfUsers();
                    this.createUser(directory, data.username, data.username, data.displayName, data.emailAddress, !willExceedLicense, false);
                    if (willExceedLicense) {
                        log.warn("Not adding {} to {}; there are already {} licensed users", new Object[]{data.username, "stash-users", licensedUsers});
                        continue;
                    }
                    log.info("Created regular user '{}'", (Object)data.username);
                    ++licensedUsers;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected String getBaseUrlMachineName() {
        try {
            if (this.initBaseUrlWithMachineHost()) {
                return InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "localhost";
    }

    private boolean initBaseUrlWithMachineHost() {
        return Boolean.getBoolean("stash.dev.init.baseurl.with.machine.host");
    }

    private static class UserData {
        private final String displayName;
        private final String username;
        private final String emailAddress;

        private UserData(String username, String displayName, String emailAddress) {
            this.username = username;
            this.displayName = displayName;
            this.emailAddress = emailAddress;
        }
    }
}

