/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.check;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import com.atlassian.bitbucket.server.ApplicationMode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LicensingCheck
implements ScmRequestCheck {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final ApplicationMode mode;
    private final NavBuilder navBuilder;

    @Autowired
    public LicensingCheck(LicenseService licenseService, I18nService i18nService, NavBuilder navBuilder, AuthenticationContext authenticationContext, @Value(value="#{applicationPropertiesService.mode}") ApplicationMode mode) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.mode = mode;
        this.navBuilder = navBuilder;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        KeyedMessage message;
        if (this.mode == ApplicationMode.MIRROR) {
            return true;
        }
        if (this.authenticationContext.isAuthenticated() && !this.licenseService.canLogin((Principal)this.authenticationContext.getCurrentUser())) {
            request.sendError(this.i18nService.getMessage("bitbucket.scm.unlicensed.user", new Object[0]), this.i18nService.getMessage("bitbucket.scm.unlicensed.user.detail", new Object[]{Product.NAME}));
            return false;
        }
        if (request.isWrite() && !this.licenseService.isLicenseValid() && (message = this.licenseService.getStatus()) != null) {
            request.sendError(this.i18nService.getMessage("bitbucket.scm.license.limit.exceeded", new Object[0]), this.i18nService.getMessage("bitbucket.scm.license.limit.exceeded.detail", new Object[]{Product.NAME, this.navBuilder.buildAbsolute(), message.getLocalisedMessage()}));
            return false;
        }
        return true;
    }
}

