/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.check;

import com.atlassian.bitbucket.dmz.user.AuthorizationFailureEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryAuthorizationCheck
implements ScmRequestCheck {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;

    @Autowired
    public RepositoryAuthorizationCheck(EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        Repository repository = request.getRepository();
        if (this.isAuthorized(repository, request.isWrite())) {
            return true;
        }
        if (request.isWrite() && this.permissionService.isRepositoryAccessible(repository)) {
            this.eventPublisher.publish((Object)new AuthorizationFailureEvent((Object)this));
            request.sendError(this.i18nService.getMessage("bitbucket.scm.insufficient.permissions", new Object[0]), this.i18nService.getMessage("bitbucket.scm.insufficient.permissions.detail", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        }
        return false;
    }

    private boolean isAuthorized(Repository repository, boolean write) {
        if (write) {
            return this.permissionService.hasRepositoryPermission(repository, Permission.REPO_WRITE);
        }
        return this.permissionService.isRepositoryAccessible(repository);
    }
}

