/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.check;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryStateCheck
implements ScmRequestCheck {
    private final I18nService i18nService;

    @Autowired
    public RepositoryStateCheck(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        Repository repository = request.getRepository();
        if (request.isWrite() && repository.isReadOnly()) {
            request.sendError(this.i18nService.getMessage("bitbucket.scm.repository.readonly", new Object[0]), this.i18nService.getMessage("bitbucket.scm.repository.readonly.detail", new Object[0]));
            return false;
        }
        Repository.State state = repository.getState();
        if (state == Repository.State.AVAILABLE || state == Repository.State.OFFLINE) {
            return true;
        }
        request.sendError(this.i18nService.getMessage("bitbucket.scm.repository.not.available", new Object[0]), this.i18nService.getMessage("bitbucket.scm.repository.not.available.details", new Object[]{repository.getProject().getKey(), repository.getSlug()}));
        return false;
    }
}

