/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="clusterIdManager")
public class ClusterIdManager {
    @VisibleForTesting
    static final String LOCK_NAME = ClusterIdManager.class.getName();
    private static final Logger log = LoggerFactory.getLogger(ClusterIdManager.class);
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final LockService lockService;
    private final NutclusterInstance nutcluster;

    @Autowired
    public ClusterIdManager(InternalApplicationPropertiesService applicationPropertiesService, NutclusterInstance nutcluster, LockService lockService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.nutcluster = nutcluster;
        this.lockService = lockService;
    }

    @Nonnull
    public String getClusterId() {
        String clusterId = this.applicationPropertiesService.getClusterId();
        if (clusterId == null) {
            log.debug("Cluster ID not found on cache, resetting value");
            clusterId = this.resetClusterId();
        }
        return clusterId;
    }

    @PostConstruct
    public void initialize() {
        this.resetClusterId();
    }

    private String resetClusterId() {
        String oldestMemberId = ((Member)this.nutcluster.getCluster().getMembers().iterator().next()).getStringAttribute("node.vm.id");
        String storedId = this.applicationPropertiesService.getClusterId();
        if (Objects.equals(storedId, oldestMemberId)) {
            log.debug("Cache already contains up-to-date cluster ID '{}'", (Object)oldestMemberId);
            return oldestMemberId;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(LOCK_NAME));){
            storedId = this.applicationPropertiesService.getClusterId();
            if (Objects.equals(storedId, oldestMemberId)) {
                log.debug("Cache already contains up-to-date cluster ID '{}'", (Object)oldestMemberId);
                String string = oldestMemberId;
                return string;
            }
            log.debug("Updating cluster ID cache from '{}' to '{}'", (Object)storedId, (Object)oldestMemberId);
            this.applicationPropertiesService.setClusterId(oldestMemberId);
        }
        return oldestMemberId;
    }
}

