/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ClusterJoinCheckResult {
    public static final ClusterJoinCheckResult OK = new Builder().build();
    private final ClusterJoinCheckAction action;
    private final ImmutableList<String> messages;

    private ClusterJoinCheckResult(ClusterJoinCheckAction action, ImmutableList<String> messages) {
        this.action = Objects.requireNonNull(action, "action");
        this.messages = Objects.requireNonNull(messages, "messages");
    }

    @Nonnull
    public static ClusterJoinCheckResult disconnect(@Nonnull String message) {
        return new Builder().disconnect(message).build();
    }

    @Nonnull
    public static ClusterJoinCheckResult passivate(@Nonnull ClusterJoinCheckAction action, @Nonnull String message) {
        return new Builder().passivate(action, message).build();
    }

    @Nonnull
    public ClusterJoinCheckAction getAction() {
        return this.action;
    }

    @Nonnull
    public ImmutableList<String> getMessages() {
        return this.messages;
    }

    public static class Builder {
        private final ImmutableList.Builder<String> messages = ImmutableList.builder();
        private ClusterJoinCheckAction action = ClusterJoinCheckAction.CONNECT;

        @Nonnull
        public ClusterJoinCheckResult build() {
            return new ClusterJoinCheckResult(this.action, (ImmutableList<String>)this.messages.build());
        }

        @Nonnull
        public Builder action(@Nonnull ClusterJoinCheckAction action, @Nonnull String message) {
            this.messages.add((Object)Objects.requireNonNull(message, "message"));
            if (this.action.getId() < Objects.requireNonNull(action, "action").getId()) {
                this.action = action;
            }
            return this;
        }

        @Nonnull
        public Builder disconnect(@Nonnull String message) {
            return this.action(ClusterJoinCheckAction.DISCONNECT, message);
        }

        @Nonnull
        public Builder passivate(@Nonnull ClusterJoinCheckAction action, @Nonnull String message) {
            Preconditions.checkArgument((boolean)Objects.requireNonNull(action, "action").isPassivate(), (String)"%s incompatible with passivate", (Object)((Object)action));
            return this.action(action, message);
        }
    }
}

