/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="clusterSupportData")
public class ClusterSupportData
extends RootLevelSupportDataAppender {
    private static final String CLUSTER = "bitbucket.atst.cluster";
    private static final String CLUSTER_AVAILABLE = "bitbucket.atst.cluster.available";
    private static final String CLUSTER_CLUSTERED = "bitbucket.atst.cluster.clustered";
    private static final String CLUSTER_NODE = "bitbucket.atst.cluster-node";
    private static final String CLUSTER_NODE_ADDRESS = "bitbucket.atst.cluster-node.address";
    private static final String CLUSTER_NODE_AVAILABILITY_ZONE = "bitbucket.atst.cluster-node.availability-zone";
    private static final String CLUSTER_NODE_ID = "bitbucket.atst.cluster-node.id";
    private static final String CLUSTER_NODE_LOCAL = "bitbucket.atst.cluster-node.local";
    private static final String CLUSTER_NODE_NAME = "bitbucket.atst.cluster-node.name";
    private final ClusterService clusterService;

    @Autowired
    public ClusterSupportData(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        SupportDataBuilder clusterBuilder = supportDataBuilder.addCategory(CLUSTER).addValue(CLUSTER_AVAILABLE, Boolean.toString(this.clusterService.isAvailable())).addValue(CLUSTER_CLUSTERED, Boolean.toString(this.clusterService.isClustered()));
        for (ClusterNode node : this.clusterService.getInformation().getNodes()) {
            clusterBuilder.addCategory(CLUSTER_NODE).addValue(CLUSTER_NODE_NAME, node.getName()).addValue(CLUSTER_NODE_ID, node.getId()).addValue(CLUSTER_NODE_ADDRESS, node.getAddress().toString()).addValue(CLUSTER_NODE_LOCAL, Boolean.toString(node.isLocal())).addValue(CLUSTER_NODE_AVAILABILITY_ZONE, node.getAvailabilityZone().orElse("")).addContext((Object)node);
        }
    }
}

