/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.johnson.Johnson;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.stash.internal.cluster.ClusterAuthenticationResult;
import com.atlassian.stash.internal.cluster.ClusterAuthenticator;
import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinManager;
import com.atlassian.stash.internal.cluster.ClusterJoinMode;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.cluster.NodeConnectionException;
import com.atlassian.stash.internal.config.Clock;
import com.atlassian.stash.internal.johnson.JohnsonUtils;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.OrderComparator;
import org.springframework.stereotype.Component;

@Component(value="clusterJoinManager")
public class DefaultClusterJoinManager
implements ClusterJoinManager {
    private static final int LIST_MAX_LENGTH = 50;
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterJoinManager.class);
    private final Clock clock;
    private final ClusterAuthenticator clusterAuthenticator;
    private final boolean enableNodeAuthentication;
    private final Map<String, ClusterJoinCheck> joinChecks;
    private final ServletContext servletContext;
    private final long startTime;

    @Autowired
    public DefaultClusterJoinManager(Clock clock, ClusterAuthenticator clusterAuthenticator, @Value(value="${hazelcast.node.authentication.enabled}") boolean enableNodeAuthentication, ServletContext servletContext, ClusterJoinCheck ... joinChecks) {
        this.clock = clock;
        this.clusterAuthenticator = clusterAuthenticator;
        this.enableNodeAuthentication = enableNodeAuthentication;
        this.servletContext = servletContext;
        this.startTime = clock.nanoTime();
        this.joinChecks = Arrays.stream(joinChecks).sorted((Comparator<ClusterJoinCheck>)new OrderComparator()).collect(Collectors.collectingAndThen(Collectors.toMap(ClusterJoinCheck::getName, Function.identity(), (a, b) -> {
            throw new IllegalStateException("Duplicate key: " + String.valueOf(a));
        }, LinkedHashMap::new), Collections::unmodifiableMap));
    }

    @Override
    public void accept(@Nonnull ClusterJoinRequest request) throws IOException {
        Preconditions.checkArgument((Objects.requireNonNull(request, "request").getJoinMode() == ClusterJoinMode.ACCEPT ? 1 : 0) != 0, (Object)"Expected accept request");
        this.checkAcceptingClusterConnections();
        if (this.enableNodeAuthentication) {
            log.debug("{}: Authenticating cluster node", (Object)request);
            ClusterAuthenticationResult authenticationResult = this.clusterAuthenticator.authenticate(request);
            if (!authenticationResult.isSuccessful()) {
                log.warn("{}: Node authentication failed: {} ", (Object)request, (Object)authenticationResult.getMessage());
                throw new NodeConnectionException(authenticationResult.getMessage());
            }
            log.debug("{}: Node authenticated successfully", (Object)request);
        } else {
            log.debug("{}: Node authentication disabled", (Object)request);
        }
        request.out().writeInt(this.joinChecks.size());
        for (ClusterJoinCheck joinCheck : this.joinChecks.values()) {
            Timer timer = TimerUtils.start((String)("join check " + joinCheck.getName()));
            try {
                request.out().writeUTF(joinCheck.getName());
                ClusterJoinCheckResult outcome = request.in().readBoolean() ? joinCheck.accept(request) : joinCheck.onUnknown(request);
                this.negotiateOutcome(outcome, request);
            }
            finally {
                if (timer == null) continue;
                timer.close();
            }
        }
        this.negotiateOutcome(ClusterJoinCheckResult.OK, request);
    }

    @Override
    public void connect(@Nonnull ClusterJoinRequest request) throws IOException {
        Preconditions.checkArgument((Objects.requireNonNull(request, "request").getJoinMode() == ClusterJoinMode.CONNECT ? 1 : 0) != 0, (Object)"Expected connect request");
        this.checkAcceptingClusterConnections();
        if (this.enableNodeAuthentication) {
            log.debug("{}: Authenticating cluster node", (Object)request);
            ClusterAuthenticationResult authenticationResult = this.clusterAuthenticator.authenticate(request);
            if (!authenticationResult.isSuccessful()) {
                log.warn("{}: Node authentication failed: {} ", (Object)request, (Object)authenticationResult.getMessage());
                throw new NodeConnectionException(authenticationResult.getMessage());
            }
            log.debug("{}: Node authenticated successfully", (Object)request);
        } else {
            log.debug("{}: Node authentication disabled", (Object)request);
        }
        HashSet<String> toBeChecked = new HashSet<String>(this.joinChecks.keySet());
        int numberOfChecks = request.in().readInt();
        for (int i = 0; i < numberOfChecks; ++i) {
            String checkName = request.in().readUTF();
            try (Timer ignored = TimerUtils.start((String)("join check - " + checkName));){
                ClusterJoinCheckResult outcome;
                if (toBeChecked.remove(checkName)) {
                    request.out().writeBoolean(true);
                    outcome = this.joinChecks.get(checkName).connect(request);
                } else {
                    request.out().writeBoolean(false);
                    outcome = ClusterJoinCheckResult.OK;
                }
                this.negotiateOutcome(outcome, request);
                continue;
            }
        }
        for (String checkName : toBeChecked) {
            ClusterJoinCheckResult outcome = this.joinChecks.get(checkName).onUnknown(request);
            if (outcome.getAction() == ClusterJoinCheckAction.CONNECT) continue;
            log.info("Cluster joinCheck '{}' failed with messages '{}'", (Object)checkName, (Object)StringUtils.join(outcome.getMessages(), (char)','));
            this.negotiateOutcome(outcome, request);
        }
        this.negotiateOutcome(ClusterJoinCheckResult.OK, request);
    }

    private static List<String> readList(ObjectDataInput in) throws IOException {
        String[] items;
        int length = in.readInt();
        if (length > 50) {
            log.warn("Refusing to read {} items. Items past {} will be discarded", (Object)length, (Object)50);
            items = new String[50];
        } else {
            items = new String[length];
        }
        for (int i = 0; i < length; ++i) {
            String item = in.readUTF();
            if (i >= items.length) continue;
            items[i] = item;
        }
        return Arrays.asList(items);
    }

    private static void writeList(ObjectDataOutput out, List<String> list) throws IOException {
        out.writeInt(list.size());
        for (String message : list) {
            out.writeUTF(message);
        }
    }

    private void checkAcceptingClusterConnections() throws IOException {
        if (this.isSystemUnavailable()) {
            throw new NodeConnectionException("Not accepting cluster connections at the moment");
        }
    }

    private JohnsonEventContainer getEventContainer() {
        return Johnson.getEventContainer((ServletContext)this.servletContext);
    }

    private long getUptimeNanos() {
        return this.clock.nanoTime() - this.startTime;
    }

    private boolean isSystemUnavailable() {
        String highestLevel = JohnsonUtils.findHighestEventLevel((JohnsonEventContainer)this.getEventContainer());
        return highestLevel != null && JohnsonUtils.isLevelAtLeast((String)highestLevel, (String)"error");
    }

    private void negotiateOutcome(ClusterJoinCheckResult result, ClusterJoinRequest request) throws IOException {
        ClusterJoinCheckAction resolvedAction;
        ClusterJoinCheckAction remoteAction;
        ClusterJoinCheckAction localAction = result.getAction();
        request.out().writeInt(result.getAction().getId());
        if (localAction != ClusterJoinCheckAction.CONNECT) {
            DefaultClusterJoinManager.writeList(request.out(), result.getMessages());
        }
        if ((remoteAction = ClusterJoinCheckAction.forId(request.in().readInt())) == ClusterJoinCheckAction.CONNECT && localAction == ClusterJoinCheckAction.CONNECT) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>((Collection<String>)result.getMessages());
        if (remoteAction != ClusterJoinCheckAction.CONNECT) {
            errors.addAll(DefaultClusterJoinManager.readList(request.in()));
        }
        if ((resolvedAction = this.resolveAction(localAction, remoteAction)) == ClusterJoinCheckAction.PASSIVATE_ANY_NODE) {
            int clusterSize = request.getNutcluster().getCluster().getMembers().size();
            long uptime = this.getUptimeNanos();
            request.out().writeInt(clusterSize);
            request.out().writeLong(uptime);
            long remoteClusterSize = request.in().readInt();
            long remoteUptime = request.in().readLong();
            if (remoteClusterSize > (long)clusterSize) {
                this.passivateNode(errors);
            } else if (remoteClusterSize == (long)clusterSize && (remoteUptime > uptime || remoteUptime == uptime && request.getJoinMode() == ClusterJoinMode.CONNECT)) {
                this.passivateNode(errors);
            }
        } else if (resolvedAction == ClusterJoinCheckAction.PASSIVATE_THIS_NODE) {
            this.passivateNode(errors);
        }
        throw new NodeConnectionException(errors);
    }

    private void passivateNode(List<String> issues) {
        String error = "The current node is unable to safely connect to the cluster and will not service requests" + issues.stream().map(StringEscapeUtils::escapeHtml4).collect(Collectors.joining("</li><li>", "<ul><li>", "</li></ul>"));
        this.getEventContainer().addEvent(new Event(EventType.get((String)"node-passivated"), error, EventLevel.get((String)"error")));
    }

    private ClusterJoinCheckAction resolveAction(ClusterJoinCheckAction localAction, ClusterJoinCheckAction remoteAction) {
        switch (remoteAction) {
            case CONNECT: {
                return localAction;
            }
            case DISCONNECT: 
            case PASSIVATE_ANY_NODE: {
                return localAction.isPassivate() ? localAction : remoteAction;
            }
            case PASSIVATE_OTHER_NODE: {
                return localAction == ClusterJoinCheckAction.PASSIVATE_OTHER_NODE ? ClusterJoinCheckAction.PASSIVATE_ANY_NODE : ClusterJoinCheckAction.PASSIVATE_THIS_NODE;
            }
            case PASSIVATE_THIS_NODE: {
                return localAction == ClusterJoinCheckAction.PASSIVATE_THIS_NODE ? ClusterJoinCheckAction.PASSIVATE_ANY_NODE : ClusterJoinCheckAction.PASSIVATE_OTHER_NODE;
            }
        }
        throw new IllegalArgumentException("Unsupported ClusterJoinAction " + String.valueOf((Object)remoteAction));
    }
}

