/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberAttributeEvent;
import com.atlassian.nutcluster.core.MembershipEvent;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.stash.internal.cluster.NutclusterClusterService;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMembershipListener
implements MembershipListener {
    private static final Logger log = LoggerFactory.getLogger(NutclusterClusterService.class);

    public void memberAdded(MembershipEvent event) {
        log.info("Node '{}' was ADDED to the cluster. Updated cluster: {}", (Object)LoggingMembershipListener.getShortMemberDetails(event.getMember()), (Object)LoggingMembershipListener.getClusterDetails(event));
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
        log.debug("Attribute {}={} changed for node '{}'. Updated cluster: {}", new Object[]{event.getKey(), event.getValue(), LoggingMembershipListener.getShortMemberDetails(event.getMember()), LoggingMembershipListener.getClusterDetails((MembershipEvent)event)});
    }

    public void memberRemoved(MembershipEvent event) {
        log.info("Node '{}' was REMOVED from the cluster. Updated cluster: {}", (Object)LoggingMembershipListener.getShortMemberDetails(event.getMember()), (Object)LoggingMembershipListener.getClusterDetails(event));
    }

    private static String getClusterDetails(MembershipEvent event) {
        Set members = event.getCluster().getMembers();
        Member master = (Member)Iterables.getFirst((Iterable)members, null);
        return "\n\t" + members.stream().map(member -> LoggingMembershipListener.getMemberDetails(member, master)).collect(Collectors.joining(", \n\t"));
    }

    private static String getMemberDetails(Member member, Member master) {
        String name = member.getStringAttribute("node.name");
        String vmId = member.getStringAttribute("node.vm.id");
        StringBuilder builder = new StringBuilder("[").append(member.getSocketAddress());
        if (member.equals((Object)master)) {
            builder.append(" master");
        }
        if (member.localMember()) {
            builder.append(" this");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.append(" name='").append(name).append("'");
        }
        builder.append(" uuid='").append(member.getUuid()).append("' vm-id='").append(vmId).append("']");
        return builder.toString();
    }

    private static String getShortMemberDetails(Member member) {
        String name = member.getStringAttribute("node.name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return String.valueOf(member.getSocketAddress()) + " (" + name + ")";
        }
        return member.getSocketAddress().toString();
    }
}

