/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.nutcluster.config.JoinConfig;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class NutclusterClusterInformation
implements ClusterInformation {
    private final Cluster cluster;
    private final NutclusterInstance nutcluster;

    public NutclusterClusterInformation(NutclusterInstance nutcluster) {
        this.nutcluster = Objects.requireNonNull(nutcluster, "nutcluster");
        this.cluster = Objects.requireNonNull(nutcluster.getCluster(), "nutcluster.cluster");
    }

    @Nonnull
    public ClusterNode getLocalNode() {
        return new NutclusterClusterNode(this.cluster.getLocalMember());
    }

    @Nonnull
    public Set<ClusterNode> getNodes() {
        return NutclusterClusterNode.sort(NutclusterClusterNode.transform(this.cluster.getMembers()));
    }

    public boolean isNetworkingEnabled() {
        JoinConfig join = this.nutcluster.getConfig().getNetworkConfig().getJoin();
        return join.getTcpIpConfig().isEnabled() || join.getMulticastConfig().isEnabled() || join.getAwsConfig().isEnabled() || join.getGcpConfig().isEnabled() || join.getAzureConfig().isEnabled() || join.getKubernetesConfig().isEnabled() || join.getEurekaConfig().isEnabled() || join.getDiscoveryConfig().isEnabled();
    }

    public boolean isRunning() {
        return this.nutcluster.getLifecycleService().isRunning();
    }
}

