/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import jakarta.annotation.Nonnull;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@CustomSoyDataMapper(value="ClusterNode")
public class NutclusterClusterNode
implements ClusterNode {
    private static final Comparator<? super ClusterNode> ORDERING = Comparator.comparing(ClusterNode::getId);
    protected final Member member;
    private final String name;

    public NutclusterClusterNode(Member member) {
        this.member = Objects.requireNonNull(member, "member");
        this.name = member.getStringAttribute("node.name");
    }

    @Nonnull
    public static ClusterNode transform(@Nonnull Member member) {
        return new NutclusterClusterNode(member);
    }

    @Nonnull
    public static Set<ClusterNode> transform(@Nonnull Set<Member> members) {
        return (Set)members.stream().map(NutclusterClusterNode::new).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public static Set<ClusterNode> sort(@Nonnull Set<ClusterNode> members) {
        return (Set)members.stream().sorted(ORDERING).collect(MoreCollectors.toImmutableSet());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NutclusterClusterNode) {
            NutclusterClusterNode n = (NutclusterClusterNode)o;
            return this.member.equals((Object)n.member);
        }
        return false;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        InetSocketAddress socketAddress = this.member.getSocketAddress();
        return socketAddress != null ? socketAddress : InetSocketAddress.createUnresolved(this.member.getAddress().getHost(), this.member.getAddress().getPort());
    }

    @Nonnull
    public Optional<String> getAvailabilityZone() {
        return Optional.ofNullable(this.member.getStringAttribute("hazelcast.partition.group.zone"));
    }

    @Nonnull
    public Version getBuildVersion() {
        return new Version(this.member.getStringAttribute("node.build.version"));
    }

    @Nonnull
    public String getId() {
        return this.member.getUuid().toString();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Member getMember() {
        return this.member;
    }

    @Nonnull
    public String getVmId() {
        return this.member.getStringAttribute("node.vm.id");
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean isFullyStarted() {
        return !this.member.isLiteMember();
    }

    public boolean isLocal() {
        return this.member.localMember();
    }

    public String toString() {
        return this.getId() + " listening on " + String.valueOf(this.getAddress());
    }
}

