/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.PartitionService;
import com.atlassian.stash.internal.cluster.ClusterPartitionService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="clusterPartitionService")
public class NutclusterClusterPartitionService
implements ClusterPartitionService {
    private final PartitionService partitionService;

    @Autowired
    public NutclusterClusterPartitionService(NutclusterInstance nutcluster) {
        this.partitionService = nutcluster.getPartitionService();
    }

    public boolean belongsToLocalPartition(@Nonnull Object key) {
        Objects.requireNonNull(key, "key");
        Member owner = this.partitionService.getPartition(key).getOwner();
        return owner != null && owner.localMember();
    }
}

