/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.cluster.ClusterExecutionException;
import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.cluster.DmzClusterService;
import com.atlassian.bitbucket.server.ApplicationState;
import com.atlassian.bitbucket.server.ApplicationStatusService;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MembershipListener;
import com.atlassian.nutcluster.core.MultiExecutionCallback;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.cluster.ClusterIdManager;
import com.atlassian.stash.internal.cluster.LoggingMembershipListener;
import com.atlassian.stash.internal.cluster.NutclusterClusterInformation;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.maintenance.latch.ResultCollectingExecutionCallback;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(interfaces={ClusterService.class, DmzClusterService.class})
@Service(value="clusterService")
public class NutclusterClusterService
implements DmzClusterService {
    private static final Logger log = LoggerFactory.getLogger(NutclusterClusterService.class);
    private final ClusterIdManager clusterIdManager;
    private final ClusterInformation clusterInformation;
    private final IExecutorService executorService;
    private final String listenerId;
    private final int nodeStatusTimeout;
    private final NutclusterInstance nutcluster;

    @Autowired
    public NutclusterClusterService(ClusterIdManager clusterIdManager, IExecutorService executorService, NutclusterInstance nutcluster, @Value(value="${hazelcast.node.status.timeout}") int nodeStatusTimeout) {
        this.clusterIdManager = clusterIdManager;
        this.executorService = executorService;
        this.nutcluster = nutcluster;
        this.nodeStatusTimeout = nodeStatusTimeout;
        this.clusterInformation = new NutclusterClusterInformation(nutcluster);
        this.listenerId = nutcluster.getCluster().addMembershipListener((MembershipListener)new LoggingMembershipListener());
    }

    @PreDestroy
    public void destroy() {
        this.nutcluster.getCluster().removeMembershipListener(this.listenerId);
    }

    @Nonnull
    public String getClusterId() {
        return this.clusterIdManager.getClusterId();
    }

    @Nonnull
    public ClusterInformation getInformation() {
        return this.clusterInformation;
    }

    @Nonnull
    public String getNodeId() {
        return this.clusterInformation.getLocalNode().getId();
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Map<ClusterNode, ApplicationState> getNodeStates() {
        log.debug("Querying all nodes for status");
        NodeStatusCallback callback = new NodeStatusCallback();
        try {
            this.executorService.submitToAllMembers((Callable)new GetNodeState(), (MultiExecutionCallback)callback);
            callback.await(this.nodeStatusTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClusterExecutionException("Interrupted while getting status of remote nodes", (Throwable)e);
        }
        log.debug("Node status query complete");
        return callback.getResults();
    }

    public boolean isAvailable() {
        return this.nutcluster.getLifecycleService().isRunning();
    }

    public boolean isClustered() {
        return this.isAvailable() && this.nutcluster.getCluster().getMembers().size() > 1;
    }

    public boolean isLeader() {
        Member leader = this.nutcluster.getCluster().getMembers().stream().findFirst().orElse(null);
        return leader != null && leader.localMember();
    }

    private static class NodeStatusCallback
    extends ResultCollectingExecutionCallback<ApplicationState> {
        private final Map<ClusterNode, ApplicationState> results = new ConcurrentHashMap<ClusterNode, ApplicationState>();

        private NodeStatusCallback() {
        }

        public Map<ClusterNode, ApplicationState> getResults() {
            return ImmutableMap.copyOf(this.results);
        }

        @Override
        protected void onError(Member member, Throwable e) {
            log.error("Received error for {}", (Object)NutclusterClusterNode.transform(member), (Object)e);
            this.results.put(NutclusterClusterNode.transform(member), ApplicationState.UNKNOWN);
        }

        @Override
        protected void onSuccess(Member member, ApplicationState state) {
            ClusterNode node = NutclusterClusterNode.transform(member);
            log.debug("Received status of {} for {}", (Object)state, (Object)node);
            this.results.put(node, state);
        }
    }

    @SpringAware
    private static final class GetNodeState
    implements Callable<ApplicationState>,
    Serializable {
        private ApplicationStatusService applicationStatusService;

        private GetNodeState() {
        }

        @Override
        public ApplicationState call() {
            ApplicationState state = this.applicationStatusService.getState();
            log.debug("Received query for state; returning {}", (Object)state);
            return state;
        }

        @Autowired
        public void setApplicationStatusService(ApplicationStatusService applicationStatusService) {
            this.applicationStatusService = applicationStatusService;
        }
    }
}

