/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.internal.serialization.impl.ObjectDataInputStream;
import com.atlassian.nutcluster.nio.Bits;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.slf4j.LoggerFactory;

public class ParanoidObjectDataInputStream
extends ObjectDataInputStream {
    private static final int UTF_LIMIT = 32768;

    public ParanoidObjectDataInputStream(InputStream in, InternalSerializationService serializationService) {
        super(in, serializationService);
    }

    public String readUTF() throws IOException {
        int charCount = this.readInt();
        if (charCount == -1) {
            return null;
        }
        if (charCount > 32768) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Rejecting request to read {} UTF characters", (Object)charCount);
            throw new UTFDataFormatException("Rejecting request to read " + charCount + " UTF characters");
        }
        char[] charBuffer = new char[charCount];
        for (int i = 0; i < charCount; ++i) {
            byte b = this.readByte();
            charBuffer[i] = b < 0 ? Bits.readUtf8Char((DataInput)((Object)this), (byte)b) : (char)b;
        }
        return new String(charBuffer, 0, charCount);
    }
}

