/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.zdu.RollingUpgradeState;
import com.atlassian.stash.internal.zdu.RollingUpgradeStateManager;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollingUpgradeClusterJoinCheck
implements ClusterJoinCheck {
    private static final String DOWNGRADED_ERROR_MESSAGE = "Upgrade mode enabled at version %s, so node running version %s was rejected.";
    private static final String VERSION_ERROR_MESSAGE = "Nodes with version %s and %s cannot form a cluster as they need to have same major and minor versions. Only bugfix updates of %s.%s are allowed to join the cluster.";
    private final BuildInfo buildInfo;
    private final RollingUpgradeStateManager rollingUpgradeStateManager;

    @Autowired
    public RollingUpgradeClusterJoinCheck(BuildInfo buildInfo, RollingUpgradeStateManager rollingUpgradeStateManager) {
        this.buildInfo = buildInfo;
        this.rollingUpgradeStateManager = rollingUpgradeStateManager;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult accept(@Nonnull ClusterJoinRequest request) throws IOException {
        return this.isCompatibleForRollingUpgrade(Objects.requireNonNull(request, "request"));
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult connect(@Nonnull ClusterJoinRequest request) throws IOException {
        return this.isCompatibleForRollingUpgrade(Objects.requireNonNull(request, "request"));
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getClass().getName();
    }

    public int getOrder() {
        return 30;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult onUnknown(@Nonnull ClusterJoinRequest request) {
        Objects.requireNonNull(request, "request");
        RollingUpgradeState rollingUpgradeState = this.rollingUpgradeStateManager.getRollingUpgradeState();
        if (!rollingUpgradeState.isUpgradeModeEnabled()) {
            return ClusterJoinCheckResult.OK;
        }
        return ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Cluster rejected a node running a version that doesn\u2019t support rolling upgrades");
    }

    private Version getOriginalVersion() {
        return (Version)this.rollingUpgradeStateManager.getRollingUpgradeState().getOriginalVersion().orElseThrow(() -> new IllegalStateException("originalVersion is not present but upgrade mode is enabled"));
    }

    private ClusterJoinCheckResult isCompatibleForRollingUpgrade(ClusterJoinRequest request) throws IOException {
        Version localVersion = new Version(this.buildInfo.getBuildVersion());
        request.out().writeUTF(localVersion.toString());
        RollingUpgradeState rollingUpgradeState = this.rollingUpgradeStateManager.getRollingUpgradeState();
        Version remoteVersion = new Version(request.in().readUTF());
        if (!rollingUpgradeState.isUpgradeModeEnabled()) {
            return ClusterJoinCheckResult.OK;
        }
        return new UpgradeModeVersionChecker(this.getOriginalVersion()).checkNotDowngraded(localVersion, ClusterJoinCheckAction.PASSIVATE_THIS_NODE).checkNotDowngraded(remoteVersion, ClusterJoinCheckAction.PASSIVATE_OTHER_NODE).checkPatchVersionsCompatibility(localVersion, remoteVersion).getResult();
    }

    private static class UpgradeModeVersionChecker {
        private final ClusterJoinCheckResult.Builder builder;
        private final Version originalVersion;

        private UpgradeModeVersionChecker(Version originalVersion) {
            this.originalVersion = originalVersion;
            this.builder = new ClusterJoinCheckResult.Builder();
        }

        private UpgradeModeVersionChecker checkNotDowngraded(Version currentVersion, ClusterJoinCheckAction passivateAction) {
            if (this.originalVersion.compareTo(currentVersion) > 0) {
                this.builder.passivate(passivateAction, String.format(RollingUpgradeClusterJoinCheck.DOWNGRADED_ERROR_MESSAGE, this.originalVersion, currentVersion)).build();
            }
            return this;
        }

        private UpgradeModeVersionChecker checkPatchVersionsCompatibility(Version localVersion, Version remoteVersion) {
            if (localVersion.getMajor() != remoteVersion.getMajor() || localVersion.getMinor() != remoteVersion.getMinor()) {
                this.builder.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, String.format(RollingUpgradeClusterJoinCheck.VERSION_ERROR_MESSAGE, localVersion, remoteVersion, this.originalVersion.getMajor(), this.originalVersion.getMinor())).build();
            }
            return this;
        }

        private ClusterJoinCheckResult getResult() {
            return this.builder.build();
        }
    }
}

