/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DefaultApplicationMode
public class SharedHomeAndDatabaseJoinCheck
implements ClusterJoinCheck {
    private static final Logger log = LoggerFactory.getLogger(SharedHomeAndDatabaseJoinCheck.class);
    private final ConfigurationService configurationService;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final HomeLayout homeLayout;
    private final SecureTokenGenerator secureTokenGenerator;

    @Autowired
    public SharedHomeAndDatabaseJoinCheck(ConfigurationService configurationService, DataSourceConfiguration dataSourceConfiguration, HomeLayout homeLayout, SecureTokenGenerator secureTokenGenerator) {
        this.configurationService = configurationService;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.homeLayout = homeLayout;
        this.secureTokenGenerator = secureTokenGenerator;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult accept(@Nonnull ClusterJoinRequest request) throws IOException {
        boolean databaseMatches;
        boolean sharedHomeMatches = this.checkSharedHome(request);
        String remoteJdbcUrl = request.in().readUTF();
        String remoteJdbcUser = request.in().readUTF();
        boolean bl = databaseMatches = this.dataSourceConfiguration.getUrl().equals(remoteJdbcUrl) && this.dataSourceConfiguration.getUser().equals(remoteJdbcUser);
        if (sharedHomeMatches) {
            if (databaseMatches) {
                return ClusterJoinCheckResult.OK;
            }
            DataSourceConfiguration onDiskConfiguration = this.configurationService.loadDataSourceConfiguration();
            boolean onDiskConfigMatchesCurrent = Objects.equals(onDiskConfiguration.getUrl(), this.dataSourceConfiguration.getUrl()) && Objects.equals(onDiskConfiguration.getUser(), this.dataSourceConfiguration.getUser());
            return ClusterJoinCheckResult.passivate(onDiskConfigMatchesCurrent ? ClusterJoinCheckAction.PASSIVATE_OTHER_NODE : ClusterJoinCheckAction.PASSIVATE_THIS_NODE, "Nodes are connected to the same shared home but different databases");
        }
        return databaseMatches ? ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Nodes are connected to the same database but different shared homes") : ClusterJoinCheckResult.disconnect("Node is part of an unrelated cluster");
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult connect(@Nonnull ClusterJoinRequest request) throws IOException {
        Path tmpFile = this.homeLayout.getSharedHomeDir().resolve(request.in().readUTF());
        boolean fileExists = Files.isRegularFile(tmpFile, new LinkOption[0]);
        request.out().writeBoolean(fileExists);
        if (fileExists) {
            String token = MoreFiles.toString((Path)tmpFile, (Charset)StandardCharsets.UTF_8);
            request.out().writeUTF(token);
        }
        request.out().writeUTF(this.dataSourceConfiguration.getUrl());
        request.out().writeUTF(this.dataSourceConfiguration.getUser());
        return ClusterJoinCheckResult.OK;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getClass().getName();
    }

    public int getOrder() {
        return 1;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult onUnknown(@Nonnull ClusterJoinRequest request) {
        return ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Cannot verify whether the nodes connect to the same database and shared home");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSharedHome(@Nonnull ClusterJoinRequest request) throws IOException {
        Path tmpFile = Files.createTempFile(this.homeLayout.getSharedHomeDir(), "cluster-join", ".txt", new FileAttribute[0]);
        try {
            String token = this.secureTokenGenerator.generateToken();
            Files.write(tmpFile, token.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            request.out().writeUTF(tmpFile.getFileName().toString());
            if (request.in().readBoolean()) {
                boolean bl = token.equals(request.in().readUTF());
                return bl;
            }
        }
        finally {
            try {
                Files.delete(tmpFile);
            }
            catch (IOException e) {
                log.warn("Failed to delete {}; will attempt to delete on exit", (Object)tmpFile, (Object)e);
                tmpFile.toFile().deleteOnExit();
            }
        }
        return false;
    }
}

