/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import aQute.lib.hex.Hex;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.security.utils.ConstantTimeComparison;
import com.atlassian.stash.internal.cluster.ClusterAuthenticationResult;
import com.atlassian.stash.internal.cluster.ClusterAuthenticator;
import com.atlassian.stash.internal.cluster.ClusterJoinMode;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.generators.SCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SharedSecretClusterAuthenticator
implements ClusterAuthenticator {
    private static final int ITERATIONS = 32768;
    private static final int MAX_NETWORK_BYTEARRAY_SIZE = 1024;
    private static final int NONCE_BYTES = 16;
    private static final Random RND = new SecureRandom();
    private static final String VERIFICATION_FAILED_MESSAGE = "Cluster authentication failed. Please make sure all members share the same value for 'nutcluster.group.name' and 'nutcluster.group.password' in bitbucket.properties.";
    private static final int VERSION = 2;
    private static final Logger log = LoggerFactory.getLogger(SharedSecretClusterAuthenticator.class);
    private final String groupName;
    private final String sharedSecret;

    @Autowired
    public SharedSecretClusterAuthenticator(@Value(value="${hazelcast.group.name}") String groupName, @Value(value="${hazelcast.group.password}") String sharedSecret) {
        this.groupName = groupName;
        this.sharedSecret = sharedSecret;
    }

    @Override
    public ClusterAuthenticationResult authenticate(@Nonnull ClusterJoinRequest request) throws IOException {
        try (Timer ignored = TimerUtils.start((String)("Cluster member authentication mode - " + String.valueOf((Object)request.getJoinMode())));){
            ClusterAuthenticationResult clusterAuthenticationResult = this.runMutualChallengeResponse(request);
            return clusterAuthenticationResult;
        }
    }

    private static byte[] readByteArray(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        if (length > 1024 || length <= 0) {
            throw new IOException("Unable to read array: invalid length: " + length);
        }
        byte[] array = new byte[length];
        in.readFully(array);
        return array;
    }

    private static void writeByteArray(ObjectDataOutput out, byte[] array) throws IOException {
        out.writeInt(array.length);
        out.write(array);
    }

    private Response createResponse(Nonce localNonce, Nonce remoteNonce, String localAddress, int localPort, boolean isConnect) throws IOException {
        byte[] salt = this.generateSalt(localNonce.nonce, remoteNonce.nonce, localAddress, localPort, isConnect);
        byte[] key = this.generateKey(salt);
        Response response = new Response(key);
        log.debug("Created: {}", (Object)response);
        return response;
    }

    private byte[] generateKey(byte[] salt) throws UnsupportedEncodingException {
        try (Timer ignored = TimerUtils.start((String)"Generate key");){
            byte[] byArray = SCrypt.generate((byte[])this.sharedSecret.getBytes(StandardCharsets.UTF_8.name()), (byte[])salt, (int)32768, (int)8, (int)1, (int)32);
            return byArray;
        }
    }

    private Nonce generateNewNonce() {
        byte[] localNonce = new byte[16];
        RND.nextBytes(localNonce);
        return new Nonce(localNonce);
    }

    private byte[] generateSalt(byte[] firstNonce, byte[] secondNonce, String address, int port, boolean isConnect) throws IOException {
        try (ByteArrayOutputStream salt = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream data = new DataOutputStream(salt);){
                data.write(firstNonce);
                data.write(secondNonce);
                data.writeBoolean(isConnect);
                data.writeInt(port);
                data.write(address.getBytes(StandardCharsets.UTF_8));
                byArray = salt.toByteArray();
            }
            return byArray;
        }
    }

    private ClusterAuthenticationResult runMutualChallengeResponse(ClusterJoinRequest request) {
        try {
            boolean isConnecting;
            ObjectDataInput in = request.in();
            ObjectDataOutput out = request.out();
            boolean bl = isConnecting = request.getJoinMode() == ClusterJoinMode.CONNECT;
            if (!this.verifyGroupName(in, out, isConnecting)) {
                return new ClusterAuthenticationResult(false, VERIFICATION_FAILED_MESSAGE);
            }
            out.writeInt(2);
            int version = in.readInt();
            if (version == -100) {
                return new ClusterAuthenticationResult(false, "Application version is incompatible. Zero Downtime Upgrades between this application version and older versions are not supported.");
            }
            if (version != 2) {
                return new ClusterAuthenticationResult(false, "Cannot form a cluster with nodes using different Bitbucket versions");
            }
            Nonce localNonce = this.generateNewNonce();
            log.trace("Generated: {}", (Object)localNonce);
            Nonce remoteNonce = new Nonce();
            Response response = new Response();
            if (isConnecting) {
                remoteNonce.readData(in);
                localNonce.writeData(out);
                response.readData(in);
                this.createResponse(localNonce, remoteNonce, request.getLocalAddress(), request.getLocalPort(), isConnecting).writeData(out);
            } else {
                localNonce.writeData(out);
                remoteNonce.readData(in);
                this.createResponse(localNonce, remoteNonce, request.getLocalAddress(), request.getLocalPort(), isConnecting).writeData(out);
                response.readData(in);
            }
            return this.verifyResponse(response, localNonce, remoteNonce, isConnecting, request.getRemoteAddress(), request.getRemotePort());
        }
        catch (IOException e) {
            return new ClusterAuthenticationResult(false, "Unexpected bytes from remote node, closing socket");
        }
    }

    private boolean verifyGroupName(ObjectDataInput in, ObjectDataOutput out, boolean isConnecting) throws IOException {
        if (isConnecting) {
            out.writeUTF(this.groupName);
            String remoteGroup = in.readUTF();
            return this.groupName.equals(remoteGroup);
        }
        String remoteGroup = in.readUTF();
        boolean result = this.groupName.equals(remoteGroup);
        if (result) {
            out.writeUTF(this.groupName);
        } else {
            out.writeUTF("");
        }
        return result;
    }

    private ClusterAuthenticationResult verifyResponse(Response message, Nonce localNonce, Nonce remoteNonce, boolean isConnect, String address, int port) throws IOException {
        byte[] proof = message.proof;
        byte[] salt = this.generateSalt(remoteNonce.nonce, localNonce.nonce, address, port, !isConnect);
        byte[] key = this.generateKey(salt);
        if (log.isTraceEnabled()) {
            log.trace("Verification: remote proof: {}", (Object)Hex.toHexString((byte[])proof));
            log.trace("Verification: local proof:  {}", (Object)Hex.toHexString((byte[])key));
        }
        return new ClusterAuthenticationResult(ConstantTimeComparison.isEqual((byte[])key, (byte[])proof), VERIFICATION_FAILED_MESSAGE);
    }

    private static final class Nonce {
        private byte[] nonce;

        public Nonce() {
        }

        Nonce(byte[] nonce) {
            this.nonce = nonce;
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.nonce = SharedSecretClusterAuthenticator.readByteArray(in);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nonce", (Object)Hex.toHexString((byte[])this.nonce)).toString();
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            SharedSecretClusterAuthenticator.writeByteArray(out, this.nonce);
        }
    }

    private static final class Response {
        private byte[] proof;

        public Response() {
        }

        Response(byte[] proof) {
            this.proof = proof;
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.proof = SharedSecretClusterAuthenticator.readByteArray(in);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("proof", (Object)Hex.toHexString((byte[])this.proof)).toString();
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            SharedSecretClusterAuthenticator.writeByteArray(out, this.proof);
        }
    }
}

