/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.SimpleChange;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class CommentCountChangeTransform
implements Function<Change, Change> {
    private static final String ACTIVE_COMMENTS = "activeComments";
    private static final String ORPHANED_COMMENTS = "orphanedComments";
    private final Map<InternalChangeLocation, CommentCounts> countsByLocation;

    public CommentCountChangeTransform(Map<InternalChangeLocation, CommentCounts> countsByLocation) {
        this.countsByLocation = Objects.requireNonNull(countsByLocation, "countsByLocation");
    }

    @Override
    public Change apply(Change change) {
        CommentCounts counts = this.countsByLocation.get(new InternalChangeLocation.Builder(change).build());
        if (counts != null) {
            PropertyMap properties = new PropertyMap.Builder().property(ACTIVE_COMMENTS, (Object)counts.getActive()).property(ORPHANED_COMMENTS, (Object)counts.getOrphaned()).build();
            return ((SimpleChange.Builder)new SimpleChange.Builder(change).properties((Map)properties)).build();
        }
        return change;
    }
}

