/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.AbstractCommentableVisitor;
import com.atlassian.bitbucket.comment.AddCommentReplyRequest;
import com.atlassian.bitbucket.comment.AddCommentRequest;
import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.AddLineCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.comment.CommentChain;
import com.atlassian.bitbucket.comment.CommentDeletionException;
import com.atlassian.bitbucket.comment.CommentOutOfDateException;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentService;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.CommentUpdateRequest;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.comment.NoSuchCommentException;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.dmz.comment.AddMultilineCommentRequest;
import com.atlassian.bitbucket.dmz.comment.DmzCommentService;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentAddRequestedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentAddedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentDeletedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentDeletionRequestedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentEditedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentModificationRequestedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentRepliedEvent;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentReplyRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentAddRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentAddedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentDeletionRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEditedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentModificationRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentRepliedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentReplyRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewCommentAddedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewCommentRepliedEvent;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestOutOfDateException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.comment.CommentSearchCriteria;
import com.atlassian.stash.internal.comment.CommentThreadDao;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentService;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.commit.CommitDiscussionDao;
import com.atlassian.stash.internal.commit.CommitDiscussionHelper;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentActivity;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipantHelper;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestDao;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={CommentService.class, DmzCommentService.class})
@Service(value="commentService")
public class DefaultCommentService
extends AbstractService
implements InternalCommentService,
DmzCommentService {
    @VisibleForTesting
    static final int DEFAULT_MAX_SPAN_LENGTH = 30;
    @VisibleForTesting
    static final String MAX_SPAN_LENGTH_PROPERTY_KEY = "plugin.multiline.comment.max.span.size";
    private final AuthenticationContext authenticationContext;
    private final CommentDao commentDao;
    private final CommentThreadDao commentThreadDao;
    private final CommitDiscussionDao commitDiscussionDao;
    private final CommitDiscussionHelper discussionHelper;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final int maxSpanLength;
    private final PermissionValidationService permissionService;
    private final CommentPostProcessor postProcessor;
    private final PullRequestActivityDao prActivityDao;
    private final PullRequestDao pullRequestDao;
    private final InternalPullRequestParticipantHelper pullRequestParticipantHelper;
    private final InternalPullRequestService pullRequestService;
    private final RepositoryActivityDao repoActivityDao;
    private final CommentUpdateProcessor updateProcessor;

    @Autowired
    public DefaultCommentService(AuthenticationContext authenticationContext, CommentDao commentDao, CommentThreadDao commentThreadDao, CommitDiscussionDao commitDiscussionDao, CommitDiscussionHelper discussionHelper, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionService, @Lazy CommentPostProcessor postProcessor, PullRequestActivityDao prActivityDao, ApplicationPropertiesService propertiesService, PullRequestDao pullRequestDao, InternalPullRequestParticipantHelper pullRequestParticipantHelper, @Lazy InternalPullRequestService pullRequestService, RepositoryActivityDao repoActivityDao, @Lazy CommentUpdateProcessor updateProcessor) {
        this.authenticationContext = authenticationContext;
        this.commentDao = commentDao;
        this.commentThreadDao = commentThreadDao;
        this.commitDiscussionDao = commitDiscussionDao;
        this.discussionHelper = discussionHelper;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.postProcessor = postProcessor;
        this.prActivityDao = prActivityDao;
        this.pullRequestDao = pullRequestDao;
        this.pullRequestParticipantHelper = pullRequestParticipantHelper;
        this.pullRequestService = pullRequestService;
        this.repoActivityDao = repoActivityDao;
        this.updateProcessor = updateProcessor;
        this.maxSpanLength = propertiesService.getPluginProperty(MAX_SPAN_LENGTH_PROPERTY_KEY, 30);
    }

    @Nonnull
    @Transactional
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public InternalComment addComment(@Nonnull AddCommentRequest request) {
        Objects.requireNonNull(request, "request");
        if (AddMultilineCommentRequest.class.isInstance(request)) {
            return this.addComment((AddMultilineCommentRequest)AddMultilineCommentRequest.class.cast(request));
        }
        if (AddLineCommentRequest.class.isInstance(request)) {
            return this.addComment((AddLineCommentRequest)AddLineCommentRequest.class.cast(request));
        }
        if (AddFileCommentRequest.class.isInstance(request)) {
            return this.addComment((AddFileCommentRequest)AddFileCommentRequest.class.cast(request));
        }
        InternalCommentable commentable = this.fetchCommentable(request);
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        this.checkPendingCommentSupported(commentable, request.isPending());
        return this.createThread(commentable, this.createComment(request.getText(), request.getSeverity(), request.isPending()), null);
    }

    @Nonnull
    @Transactional
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public InternalComment addComment(@Nonnull AddFileCommentRequest request) {
        Objects.requireNonNull(request, "request");
        if (AddLineCommentRequest.class.isInstance(request)) {
            this.addComment((AddLineCommentRequest)AddLineCommentRequest.class.cast(request));
        }
        InternalCommentable commentable = this.fetchCommentable((AddCommentRequest)request);
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        this.checkPendingCommentSupported(commentable, request.isPending());
        return this.createThread(commentable, this.createComment(request.getText(), request.getSeverity(), request.isPending()), this.createAnchor(request));
    }

    @Nonnull
    @Transactional
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public InternalComment addComment(@Nonnull AddLineCommentRequest request) {
        Objects.requireNonNull(request, "request");
        InternalCommentable commentable = this.fetchCommentable((AddCommentRequest)request);
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        this.checkFileType(request);
        this.checkPendingCommentSupported(commentable, request.isPending());
        return this.createThread(commentable, this.createComment(request.getText(), request.getSeverity(), request.isPending()), this.createAnchor(request));
    }

    @Nonnull
    @Transactional
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public InternalComment addComment(@Nonnull AddMultilineCommentRequest request) {
        Objects.requireNonNull(request, "request");
        InternalCommentable commentable = this.fetchCommentable((AddCommentRequest)request);
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        this.checkFileType((AddLineCommentRequest)request);
        this.checkMultiline(request);
        this.checkPendingCommentSupported(commentable, request.isPending());
        return this.createThread(commentable, this.createComment(request.getText(), request.getSeverity(), request.isPending()), this.createAnchor(request));
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="isAuthenticated()")
    public InternalComment addReply(@Nonnull AddCommentReplyRequest request) {
        InternalComment parent = this.getCommentOrFail(Objects.requireNonNull(request, "request").getParentId());
        InternalCommentable commentable = parent.getThread().getCommentable();
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        this.requireThreadNotResolved(parent.getThread(), "reply");
        this.checkPendingCommentSupported(commentable, request.isPending());
        if (parent.isPending() && !request.isPending()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.new.replytopending.samestate", new Object[0]));
        }
        InternalComment reply = this.createComment(request.getText(), parent, request.getSeverity(), request.isPending());
        this.requestCommentReply(reply);
        this.onCommentAdded(reply);
        return this.postProcessor.process(reply.getThread().getCommentable(), reply);
    }

    @Secured(value="Secured using internal permission checks based on the Commentable")
    public long countComments(@Nonnull CommentSearchRequest request) {
        Objects.requireNonNull(request, "request");
        this.checkPermissions(request.getCommentable(), Permission.REPO_READ);
        return this.commentDao.count(this.createCriteria(request).build());
    }

    @Secured(value="Secured using internal permission checks based on the Commentable")
    public long countThreads(@Nonnull CommentSearchRequest request) {
        Objects.requireNonNull(request, "request");
        this.checkPermissions(request.getCommentable(), Permission.REPO_READ);
        return this.commentThreadDao.count(this.createCriteria(request).build());
    }

    @Nonnull
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public Map<String, Long> countCommentsByCommit(@Nonnull InternalPullRequest pullRequest, @Nonnull Set<String> commitIds) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(commitIds, "commitIds");
        if (commitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.commentDao.countByPullRequestCommit(pullRequest.getGlobalId(), commitIds);
    }

    @Nonnull
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public Map<String, Long> countCommentsByCommit(@Nonnull InternalRepository repository, @Nonnull Set<String> commitIds) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitIds, "commitIds");
        if (commitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.commentDao.countByCommit(repository.getId(), commitIds);
    }

    @Nonnull
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public Map<InternalChangeLocation, CommentCounts> countCommentsByLocation(@Nonnull CommentSearchRequest request) {
        Objects.requireNonNull(request, "request");
        return this.commentDao.countsByLocation(this.createCriteria(request).build());
    }

    @Nonnull
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public Map<CommentState, Long> countCommentsByState(@Nonnull CommentSearchRequest request) {
        Objects.requireNonNull(request, "request");
        this.checkPermissions(request.getCommentable(), Permission.REPO_READ);
        CommentSearchCriteria searchCriteria = this.createCriteria(request).anchorState(request.getAnchorState()).build();
        return this.commentDao.countByState(searchCriteria);
    }

    @Secured(value="Secured using internal permission checks based on the Commentable")
    public long countOtherComments(@Nonnull CommentSearchRequest request) {
        Objects.requireNonNull(request, "request");
        InternalCommentable commentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        CommentSearchCriteria searchCriteria = this.createCriteria(request).anchorState(request.getAnchorState()).build();
        return this.commentDao.countOther(searchCriteria);
    }

    @Transactional
    @PreAuthorize(value="isAuthenticated()")
    public boolean deleteComment(long commentId, int version) {
        final InternalComment internal = this.getCommentOrFail(commentId, version);
        InternalCommentable commentable = internal.getThread().getCommentable();
        Permission permission = Objects.equals(this.authenticationContext.getCurrentUser(), internal.getAuthor()) ? Permission.REPO_READ : Permission.REPO_ADMIN;
        this.checkPermissions((Commentable)commentable, permission);
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        if (!internal.isPending()) {
            this.requireThreadNotResolved(internal.getThread(), "delete");
        }
        if (!internal.getComments().isEmpty()) {
            throw new CommentDeletionException(this.i18nService.createKeyedMessage("bitbucket.service.comment.delete.hasreplies", new Object[0]));
        }
        this.requestCommentDelete(internal);
        commentable.accept((CommentableVisitor)new CommentableVisitor<Void>(){

            public Void visit(@Nonnull CommitDiscussion discussion) {
                DefaultCommentService.this.repoActivityDao.deleteByComment(internal.getId());
                DefaultCommentService.this.doDeleteComment(internal);
                DefaultCommentService.this.eventPublisher.publish((Object)new CommitDiscussionCommentDeletedEvent((Object)this, discussion, (Comment)internal, (Comment)internal.getParent()));
                return null;
            }

            public Void visit(@Nonnull PullRequest pullRequest) {
                DefaultCommentService.this.prActivityDao.deleteByComment(internal.getId());
                DefaultCommentService.this.doDeleteComment(internal);
                DefaultCommentService.this.eventPublisher.publish((Object)new PullRequestCommentDeletedEvent((Object)this, pullRequest, (Comment)internal, (Comment)internal.getParent()));
                return null;
            }
        });
        return true;
    }

    @Transactional
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public boolean deletePendingComments(@Nonnull PullRequest pullRequest) {
        ApplicationUser author = this.authenticationContext.getCurrentUser();
        if (author == null) {
            return false;
        }
        CommentSearchRequest request = new CommentSearchRequest.Builder((Commentable)pullRequest).anchorState(CommentThreadDiffAnchorState.ALL).state(CommentState.PENDING).build();
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)25);
        while (pageRequest != null) {
            Page<InternalCommentThread> page = this.searchPending(pageRequest, request);
            List rootComments = page.stream().map(InternalCommentThread::getRootComment).collect(Collectors.toList());
            List pendingComments = CommentChain.of(rootComments).stream().filter(InternalComment::isPending).collect(Collectors.toList());
            Collections.reverse(pendingComments);
            this.commentDao.deleteBatch(pendingComments);
            pageRequest = page.getNextPageRequest();
        }
        return true;
    }

    @Nonnull
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public Optional<Comment> getComment(long commentId) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null || this.isPendingCommentFromDifferentUser(comment)) {
            return Optional.empty();
        }
        InternalCommentable commentable = comment.getThread().getCommentable();
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        comment.setReplyFilter(c -> c.getState() != CommentState.PENDING || c.getAuthor().equals((Object)this.authenticationContext.getCurrentUser()));
        return Optional.of(this.postProcessor.process(commentable, comment));
    }

    @Secured(value="Secured using internal permission checks based on the Commentable")
    @Transactional
    public int publishPendingComments(@Nonnull PullRequest pullRequest) {
        this.checkPermissions((Commentable)pullRequest, Permission.REPO_READ);
        this.checkNotArchived(pullRequest.getToRef().getRepository());
        Date now = new Date();
        PagedIterable comments = new PagedIterable(pageRequest -> this.commentDao.search(this.createCriteria(new CommentSearchRequest.Builder((Commentable)pullRequest).state(CommentState.PENDING).build()).anchorState(CommentThreadDiffAnchorState.ALL).build(), pageRequest), 100);
        int publishedCommentCount = 0;
        for (Comment comment : comments) {
            CommentThread commentThread = comment.getThread();
            if (commentThread.isResolved()) {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.pendingcomments.notallowed", new Object[0]));
            }
            InternalComment updatedComment = (InternalComment)this.commentDao.update((Object)new InternalComment.Builder(InternalConverter.convertToInternalComment((Comment)comment)).createdDate(now).state(CommentState.OPEN).updatedDate(now).build());
            HashSet<Long> threadIds = new HashSet<Long>();
            if (threadIds.add(commentThread.getId())) {
                this.commentThreadDao.update((Object)new InternalCommentThread.Builder(InternalConverter.convertToInternalCommentThread((CommentThread)commentThread)).updatedDate(now).build());
            }
            this.onCommentAdded(updatedComment);
            ++publishedCommentCount;
        }
        return publishedCommentCount;
    }

    @Nonnull
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public Page<Comment> search(@Nonnull CommentSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        InternalCommentable commentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        if (request.getDiffTypes().isEmpty() || request.getDiffTypes().contains(CommentThreadDiffAnchorType.EFFECTIVE)) {
            commentable.accept((CommentableVisitor)new AbstractCommentableVisitor<Void>(){

                public Void visit(@Nonnull PullRequest pullRequest) {
                    DefaultCommentService.this.updateProcessor.maybeProcess(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest));
                    return null;
                }
            });
        }
        CommentSearchCriteria searchCriteria = this.createCriteria(request).anchorState(request.getAnchorState()).build();
        Page comments = this.commentDao.search(searchCriteria, pageRequest);
        if (!request.getStates().contains(CommentState.PENDING)) {
            comments.forEach(comment -> comment.setReplyFilter(c -> c.getState() != CommentState.PENDING));
        } else {
            comments.forEach(comment -> comment.setReplyFilter(c -> c.getState() != CommentState.PENDING || c.getAuthor().equals((Object)this.authenticationContext.getCurrentUser())));
        }
        this.postProcessor.processComments(commentable, (Set)comments.stream().collect(MoreCollectors.toImmutableSet()));
        return PageUtils.asPageOf(Comment.class, (Page)comments);
    }

    @Nonnull
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public Page<CommentThread> searchOtherThreads(@Nonnull CommentSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        InternalCommentable commentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        CommentSearchCriteria searchCriteria = this.createCriteria(request).anchorState(request.getAnchorState()).build();
        Page threads = this.commentThreadDao.searchOther(searchCriteria, pageRequest);
        this.filterPendingReplies(request, threads.getValues());
        this.postProcessor.processRoots(commentable, (Set)threads.stream().map(InternalCommentThread::getRootComment).collect(MoreCollectors.toImmutableSet()));
        return PageUtils.asPageOf(CommentThread.class, (Page)threads);
    }

    @Nonnull
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public List<InternalCommentThread> searchThreads(@Nonnull CommentSearchRequest request) {
        return this.searchThreads(request, true, true);
    }

    @Nonnull
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public List<InternalCommentThread> searchThreads(@Nonnull CommentSearchRequest request, boolean enrich, boolean limitPendingComments) {
        Objects.requireNonNull(request, "request");
        InternalCommentable commentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        CommentSearchCriteria searchCriteria = this.createCriteria(request, limitPendingComments).anchorState(request.getAnchorState()).build();
        List threads = this.commentThreadDao.search(searchCriteria);
        if (limitPendingComments) {
            this.filterPendingReplies(request, threads);
        }
        if (enrich) {
            this.postProcessor.processRoots(commentable, (Set)threads.stream().map(InternalCommentThread::getRootComment).collect(MoreCollectors.toImmutableSet()));
        }
        return ImmutableList.copyOf((Collection)threads);
    }

    @Nonnull
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public Page<CommentThread> searchThreads(@Nonnull CommentSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        InternalCommentable commentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        if (request.getDiffTypes().isEmpty() || request.getDiffTypes().contains(CommentThreadDiffAnchorType.EFFECTIVE)) {
            commentable.accept((CommentableVisitor)new AbstractCommentableVisitor<Void>(){

                public Void visit(@Nonnull PullRequest pullRequest) {
                    DefaultCommentService.this.updateProcessor.maybeProcess(InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest));
                    return null;
                }
            });
        }
        CommentSearchCriteria searchCriteria = this.createCriteria(request).anchorState(request.getAnchorState()).build();
        Page threads = this.commentThreadDao.search(searchCriteria, pageRequest);
        this.filterPendingReplies(request, threads.getValues());
        this.postProcessor.processRoots(commentable, (Set)threads.stream().map(InternalCommentThread::getRootComment).collect(MoreCollectors.toImmutableSet()));
        return PageUtils.asPageOf(CommentThread.class, (Page)threads);
    }

    @Nonnull
    @Secured(value="Secured using internal permission checks based on the Commentable")
    public Page<CommentThread> searchThreadsWithPending(@Nonnull CommentSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        InternalCommentable commentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
        Page<InternalCommentThread> threads = this.searchPending(pageRequest, request);
        this.postProcessor.processRoots(commentable, (Set)threads.stream().map(InternalCommentThread::getRootComment).collect(MoreCollectors.toImmutableSet()));
        return PageUtils.asPageOf(CommentThread.class, threads);
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public InternalComment updateComment(@Nonnull CommentUpdateRequest request) {
        Objects.requireNonNull(request, "request");
        InternalComment internal = this.getCommentOrFail(request.getCommentId(), request.getVersion());
        InternalCommentThread thread = internal.getThread();
        InternalCommentable commentable = thread.getCommentable();
        this.checkNotArchived((Repository)commentable.getScopeRepository());
        String previousText = internal.getText();
        String commentText = StringUtils.isBlank((CharSequence)request.getText()) ? previousText : request.getText();
        boolean isTextChanged = !StringUtils.equals((CharSequence)previousText, (CharSequence)commentText);
        CommentSeverity previousSeverity = internal.getSeverity();
        boolean isSeverityChanged = request.getSeverity() == null ? false : previousSeverity != request.getSeverity();
        this.checkUpdatePermissions(internal, commentable, isTextChanged);
        InternalComment.Builder builder = new InternalComment.Builder(internal).text(commentText);
        CommentState previousState = internal.getState();
        if (previousState == CommentState.PENDING && request.getState() != null && request.getState() != CommentState.PENDING) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.pending.cannot.resolve", new Object[0]));
        }
        InternalComment parent = internal.getParent();
        CommentState requestState = request.getState();
        if (previousSeverity != CommentSeverity.BLOCKER && requestState == CommentState.RESOLVED && parent != null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.cannot.resolve", new Object[0]));
        }
        if (request.getThreadResolved().isPresent()) {
            if (parent != null) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.thread.cannot.resolve.reply", new Object[0]));
            }
            commentable.accept((CommentableVisitor)new AbstractCommentableVisitor<Void>(){

                public Void visit(@Nonnull CommitDiscussion discussion) {
                    throw new ArgumentValidationException(DefaultCommentService.this.i18nService.createKeyedMessage("bitbucket.service.comment.thread.commit.cannot.resolve", new Object[0]));
                }
            });
            boolean threadResolved = (Boolean)request.getThreadResolved().get();
            if (thread.isResolved() != threadResolved) {
                InternalCommentThread.Builder commentThreadBuilder = new InternalCommentThread.Builder(thread);
                if (threadResolved) {
                    commentThreadBuilder.resolve(InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser()));
                } else {
                    commentThreadBuilder.unresolve();
                }
                this.commentThreadDao.update((Object)commentThreadBuilder.build());
                this.updateDateAndOrSeverity(request, isTextChanged, isSeverityChanged, builder);
            } else if (isTextChanged || isSeverityChanged) {
                this.requireThreadNotResolved(thread, "update");
                this.updateDateAndOrSeverity(request, isTextChanged, isSeverityChanged, builder);
            }
        } else if (isTextChanged || isSeverityChanged) {
            this.requireThreadNotResolved(thread, "update");
            this.updateDateAndOrSeverity(request, isTextChanged, isSeverityChanged, builder);
        }
        if (requestState == CommentState.OPEN && previousState != CommentState.OPEN) {
            builder.unresolve();
        } else if (requestState == CommentState.RESOLVED && previousState != CommentState.RESOLVED) {
            builder.resolve(InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser()));
        }
        InternalComment updated = (InternalComment)this.commentDao.update((Object)builder.build());
        if (this.shouldFireEvent(updated.isPending(), previousState, requestState, previousSeverity)) {
            this.requestCommentEdit(updated, previousText);
            this.onCommentEdited((Commentable)commentable, updated, previousText, previousSeverity, previousState);
        }
        return this.postProcessor.process(commentable, updated);
    }

    @Transactional
    @Unsecured(value="This is an internal API. Any permission checks should have already been performed by the caller")
    public void updateThreads(@Nonnull Stream<InternalCommentThread> threads) {
        Objects.requireNonNull(threads, "threads").forEach(arg_0 -> ((CommentThreadDao)this.commentThreadDao).update(arg_0));
    }

    private void addActivity(InternalCommitDiscussion discussion, InternalComment comment, CommentAction commentAction) {
        this.repoActivityDao.create((Object)((InternalCommitDiscussionCommentActivity.Builder)((InternalCommitDiscussionCommentActivity.Builder)new InternalCommitDiscussionCommentActivity.Builder(discussion).comment(comment).commentAction(commentAction).createdDate(new Date())).user(InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser()))).build());
    }

    private void addActivity(InternalPullRequest pullRequest, InternalComment comment, CommentAction commentAction) {
        InternalPullRequestCommentActivity activity = ((InternalPullRequestCommentActivity.Builder)((InternalPullRequestCommentActivity.Builder)new InternalPullRequestCommentActivity.Builder(pullRequest).comment(comment).commentAction(commentAction).createdDate(new Date())).user(InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser()))).build();
        this.prActivityDao.create((Object)activity);
        this.eventPublisher.publish((Object)new PullRequestCommentActivityEvent((Object)this, (PullRequestCommentActivity)activity));
    }

    private void checkFileType(AddLineCommentRequest request) {
        if (request.getLineType() == DiffSegmentType.REMOVED && request.getFileType() != DiffFileType.FROM) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.error.filetype", new Object[]{DiffSegmentType.REMOVED, DiffFileType.FROM, request.getFileType()}));
        }
        if (request.getLineType() == DiffSegmentType.ADDED && request.getFileType() != DiffFileType.TO) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.error.filetype", new Object[]{DiffSegmentType.ADDED, DiffFileType.TO, request.getFileType()}));
        }
    }

    private void checkMultiline(AddMultilineCommentRequest request) {
        if (request.getStartLine() < 1) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.startline", new Object[0]));
        }
        if (request.getStartLineType() == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.startlinetype", new Object[0]));
        }
        if (request.getSourceSpan() == null && request.getDestinationSpan() == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.spansmissing", new Object[0]));
        }
        if (request.getStartLine() == request.getLine() && request.getLineType() == DiffSegmentType.CONTEXT && request.getStartLineType() == DiffSegmentType.CONTEXT) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.singlelinecontext", new Object[0]));
        }
        if (request.getSourceSpan() != null) {
            this.validateSpanLength(request.getSourceSpan());
            if (request.getDestinationSpan() != null && request.getStartLine() != request.getSourceSpan().minimum() && request.getStartLine() != request.getDestinationSpan().minimum()) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.nostartlinematch", new Object[0]));
            }
            if (request.getDestinationSpan() == null && request.getSourceSpan().isSingleLine()) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.singlelinesrc", new Object[0]));
            }
        }
        if (request.getDestinationSpan() != null) {
            this.validateSpanLength(request.getDestinationSpan());
            if (request.getSourceSpan() != null && request.getLine() != request.getSourceSpan().maximum() && request.getLine() != request.getDestinationSpan().maximum()) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.noendlinematch", new Object[0]));
            }
            if (request.getSourceSpan() == null && request.getDestinationSpan().isSingleLine()) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.singlelinedst", new Object[0]));
            }
        }
    }

    private void validateSpanLength(LineNumberRange span) {
        if (span.maximum() - span.minimum() + 1 > this.maxSpanLength) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.multiline.error.spanlength", new Object[]{this.maxSpanLength}));
        }
    }

    private void checkNotArchived(Repository repo) {
        if (repo.isArchived()) {
            throw new RepositoryArchivedException(this.i18nService.getKeyedText(new I18nKey("bitbucket.service.comment.error.repoarchived", new Object[0])));
        }
    }

    private void checkPermissions(Commentable commentable, Permission permission) {
        this.permissionService.validateForRepository((Repository)commentable.accept((CommentableVisitor)new CommentableVisitor<Repository>(this){

            public Repository visit(@Nonnull CommitDiscussion discussion) {
                return discussion.getRepository();
            }

            public Repository visit(@Nonnull PullRequest pullRequest) {
                return pullRequest.getToRef().getRepository();
            }
        }), permission);
    }

    private void checkUpdatePermissions(InternalComment internal, InternalCommentable commentable, boolean withText) {
        InternalApplicationUser commentAuthor = internal.getAuthor();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (withText && ObjectUtils.notEqual((Object)currentUser, (Object)commentAuthor)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.update.otheruser", new Object[0]));
        }
        this.checkPermissions((Commentable)commentable, Permission.REPO_READ);
    }

    private void checkPendingCommentSupported(InternalCommentable commentable, boolean pending) {
        if (pending) {
            commentable.accept((CommentableVisitor)new AbstractCommentableVisitor<Void>(){

                public Void visit(@Nonnull CommitDiscussion discussion) {
                    throw new ArgumentValidationException(DefaultCommentService.this.i18nService.createKeyedMessage("bitbucket.service.comment.pending.supported.onlyonpullrequests", new Object[0]));
                }
            });
        }
    }

    private void checkVersion(int expectedVersion, int actualVersion) {
        if (actualVersion != expectedVersion) {
            throw new CommentOutOfDateException(this.i18nService.createKeyedMessage("bitbucket.service.comment.outofdate", new Object[0]), expectedVersion, actualVersion);
        }
    }

    private InternalCommentThreadDiffAnchor createAnchor(AddFileCommentRequest request) {
        return this.newAnchorBuilder(request).apply(request).build();
    }

    private InternalCommentThreadDiffAnchor createAnchor(AddLineCommentRequest request) {
        return this.newAnchorBuilder((AddFileCommentRequest)request).apply(request).build();
    }

    private InternalCommentThreadDiffAnchor createAnchor(AddMultilineCommentRequest request) {
        return this.newAnchorBuilder((AddFileCommentRequest)request).apply(request).build();
    }

    private InternalComment createComment(String text, @Nullable CommentSeverity severity, boolean isPending) {
        return this.createComment(text, null, severity, isPending);
    }

    private InternalComment createComment(String text, InternalComment parent, @Nullable CommentSeverity severity, boolean isPending) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.new.requirestext", new Object[0]));
        }
        InternalComment.Builder builder = new InternalComment.Builder().author(InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser())).text(text).parent(parent);
        if (severity != null) {
            builder.severity(severity);
        }
        if (isPending) {
            builder.state(CommentState.PENDING);
        }
        return (InternalComment)this.commentDao.create((Object)builder.build());
    }

    private CommentSearchCriteria.Builder createCriteria(@Nonnull CommentSearchRequest request) {
        return this.createCriteria(request, true);
    }

    private CommentSearchCriteria.Builder createCriteria(@Nonnull CommentSearchRequest request, boolean limitPendingCommentsToCurrentUser) {
        InternalCommentable internalCommentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        CommentSearchCriteria.Builder builder = new CommentSearchCriteria.Builder(internalCommentable).diffTypes((Iterable)request.getDiffTypes()).fromHash(request.getFromHash()).path(request.getPath()).toHash(request.getToHash());
        if (!request.getSeverities().isEmpty()) {
            builder.severities((Iterable)request.getSeverities());
        }
        if (!request.getStates().isEmpty()) {
            builder.states((Iterable)request.getStates());
        } else {
            builder.states(EnumSet.of(CommentState.OPEN, CommentState.RESOLVED));
        }
        if (request.getAuthor() != null) {
            builder.author(InternalConverter.convertToInternalUser((ApplicationUser)request.getAuthor()));
        }
        if (limitPendingCommentsToCurrentUser) {
            ApplicationUser user = this.authenticationContext.getCurrentUser();
            if (user != null) {
                builder.pendingAuthor(InternalConverter.convertToInternalUser((ApplicationUser)user));
            } else {
                builder.omitPendingComments();
            }
        }
        return builder;
    }

    private InternalComment createThread(InternalCommentable commentable, InternalComment comment, InternalCommentThreadDiffAnchor anchor) {
        InternalCommentThread thread = (InternalCommentThread)this.commentThreadDao.create((Object)new InternalCommentThread.Builder(commentable, comment).anchor(anchor).build());
        InternalComment updated = (InternalComment)this.commentDao.update((Object)new InternalComment.Builder(thread.getRootComment()).thread(thread).build());
        this.requestCommentAdd(updated);
        this.onCommentAdded(updated);
        return this.postProcessor.process(commentable, updated);
    }

    private void doDeleteComment(InternalComment comment) {
        if (comment.getParent() == null) {
            this.commentThreadDao.delete((Object)comment.getThread());
        } else {
            this.commentDao.delete((Object)comment);
        }
    }

    private InternalComment getCommentOrFail(long commentId) {
        InternalComment comment = (InternalComment)this.commentDao.getById((Object)commentId);
        if (comment == null || this.isPendingCommentFromDifferentUser(comment)) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("bitbucket.service.comment.error.nosuchcomment", new Object[]{commentId}));
        }
        return comment;
    }

    private InternalComment getCommentOrFail(long commentId, int expectedVersion) {
        InternalComment comment = this.getCommentOrFail(commentId);
        this.checkVersion(expectedVersion, comment.getVersion());
        return comment;
    }

    private InternalCommentable fetchCommentable(AddCommentRequest request) {
        InternalCommentable internalCommentable = InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable());
        if (internalCommentable instanceof InternalPullRequest) {
            InternalPullRequest providedPullRequest = (InternalPullRequest)internalCommentable;
            InternalPullRequest fetchedPullRequest = (InternalPullRequest)this.pullRequestDao.getById((Object)providedPullRequest.getGlobalId());
            if (fetchedPullRequest == null) {
                throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.global.nosuchrequest", new Object[]{providedPullRequest.getId()}));
            }
            return fetchedPullRequest;
        }
        if (internalCommentable instanceof InternalCommitDiscussion) {
            InternalCommitDiscussion providedCommitDiscussion = (InternalCommitDiscussion)internalCommentable;
            InternalCommitDiscussion fetchedCommitDiscussion = (InternalCommitDiscussion)this.commitDiscussionDao.getById((Object)providedCommitDiscussion.getId());
            if (fetchedCommitDiscussion == null) {
                throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.service.commit.discussionnotfound", new Object[]{providedCommitDiscussion.getId()}));
            }
            return fetchedCommitDiscussion;
        }
        throw new IllegalStateException(String.format("Unknown InternalCommentable type %s", internalCommentable.getClass()));
    }

    private void filterPendingReplies(@Nonnull CommentSearchRequest request, Iterable<InternalCommentThread> threads) {
        if (!request.getStates().contains(CommentState.PENDING)) {
            threads.forEach(thread -> thread.getRootComment().setReplyFilter(comment -> comment.getState() != CommentState.PENDING));
        } else {
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            threads.forEach(thread -> thread.getRootComment().setReplyFilter(comment -> comment.getState() != CommentState.PENDING || comment.getAuthor().equals((Object)currentUser)));
        }
    }

    private boolean isPendingCommentFromDifferentUser(InternalComment comment) {
        return comment.isPending() && !comment.getAuthor().equals((Object)this.authenticationContext.getCurrentUser());
    }

    private InternalCommentThreadDiffAnchor.Builder newAnchorBuilder(final AddFileCommentRequest request) {
        return (InternalCommentThreadDiffAnchor.Builder)request.getCommentable().accept((CommentableVisitor)new CommentableVisitor<InternalCommentThreadDiffAnchor.Builder>(){

            public InternalCommentThreadDiffAnchor.Builder visit(@Nonnull CommitDiscussion discussion) {
                InternalCommitDiscussion internal = InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)discussion);
                return new InternalCommentThreadDiffAnchor.Builder(CommentThreadDiffAnchorType.COMMIT, request.getPath(), discussion.getCommitId()).fromHash(request.getFromHash() == null ? internal.getParentId() : request.getFromHash());
            }

            public InternalCommentThreadDiffAnchor.Builder visit(@Nonnull PullRequest pullRequest) {
                if (request.getDiffType() == CommentThreadDiffAnchorType.EFFECTIVE) {
                    PullRequestEffectiveDiff effectiveDiff = DefaultCommentService.this.pullRequestService.getEffectiveDiff(pullRequest);
                    if (request.getToHash() != null) {
                        this.checkEffectiveDiffHashes(pullRequest, effectiveDiff, request.getFromHash(), request.getToHash());
                    }
                    return new InternalCommentThreadDiffAnchor.Builder(CommentThreadDiffAnchorType.EFFECTIVE, request.getPath(), effectiveDiff.getUntilId()).fromHash(effectiveDiff.getSinceId());
                }
                this.checkDiffHashes(request);
                return new InternalCommentThreadDiffAnchor.Builder(request.getDiffType(), request.getPath(), request.getToHash()).fromHash(request.getFromHash());
            }

            private void checkDiffHashes(AddFileCommentRequest request2) {
                if (request2.getDiffType() != CommentThreadDiffAnchorType.RANGE && request2.getDiffType() != CommentThreadDiffAnchorType.COMMIT) {
                    return;
                }
                if (request2.getFromHash() == null || request2.getToHash() == null) {
                    throw new ArgumentValidationException(DefaultCommentService.this.i18nService.createKeyedMessage("bitbucket.service.comment.pullrequest.requiredhashes", new Object[]{request2.getDiffType().name()}));
                }
            }

            private void checkEffectiveDiffHashes(PullRequest pullRequest, PullRequestEffectiveDiff effectiveDiff, String sinceId, String untilId) {
                if (!Objects.equals(effectiveDiff.getSinceId(), sinceId) || !Objects.equals(effectiveDiff.getUntilId(), untilId)) {
                    throw new PullRequestOutOfDateException(DefaultCommentService.this.i18nService.createKeyedMessage("bitbucket.service.comment.pullrequest.outofdate", new Object[0]), pullRequest, pullRequest.getVersion());
                }
            }
        });
    }

    private void onCommentAdded(final InternalComment comment) {
        final CommentAction commentAction = comment.getParent() == null ? CommentAction.ADDED : CommentAction.REPLIED;
        comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<Void>(){

            public Void visit(@Nonnull CommitDiscussion discussion) {
                InternalCommitDiscussion internal = InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)discussion);
                DefaultCommentService.this.discussionHelper.makeCurrentUserParticipantAndWatcher(internal);
                if (commentAction == CommentAction.ADDED) {
                    DefaultCommentService.this.eventPublisher.publish((Object)new CommitDiscussionCommentAddedEvent((Object)this, (CommitDiscussion)internal, (Comment)comment));
                } else {
                    DefaultCommentService.this.eventPublisher.publish((Object)new CommitDiscussionCommentRepliedEvent((Object)this, (CommitDiscussion)internal, (Comment)comment, (Comment)comment.getParent()));
                }
                DefaultCommentService.this.addActivity(internal, comment, commentAction);
                return null;
            }

            public Void visit(@Nonnull PullRequest pullRequest) {
                InternalPullRequest internal = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
                if (comment.isPending()) {
                    if (commentAction == CommentAction.ADDED) {
                        DefaultCommentService.this.eventPublisher.publish((Object)new PullRequestReviewCommentAddedEvent((Object)this, pullRequest, (Comment)comment));
                    } else {
                        DefaultCommentService.this.eventPublisher.publish((Object)new PullRequestReviewCommentRepliedEvent((Object)this, pullRequest, (Comment)comment, (Comment)comment.getParent()));
                    }
                } else {
                    DefaultCommentService.this.pullRequestParticipantHelper.makeCurrentUserParticipantAndWatcher(internal);
                    if (commentAction == CommentAction.ADDED) {
                        DefaultCommentService.this.eventPublisher.publish((Object)new PullRequestCommentAddedEvent((Object)this, pullRequest, (Comment)comment));
                    } else {
                        DefaultCommentService.this.eventPublisher.publish((Object)new PullRequestCommentRepliedEvent((Object)this, pullRequest, (Comment)comment, (Comment)comment.getParent()));
                    }
                    DefaultCommentService.this.addActivity(internal, comment, commentAction);
                }
                return null;
            }
        });
    }

    private void onCommentEdited(Commentable commentable, final InternalComment comment, final String previousText, final CommentSeverity previousSeverity, final CommentState previousState) {
        commentable.accept((CommentableVisitor)new CommentableVisitor<Void>(){

            public Void visit(@Nonnull CommitDiscussion discussion) {
                InternalCommitDiscussion internalCommentable = InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)discussion);
                DefaultCommentService.this.addActivity(internalCommentable, comment, CommentAction.EDITED);
                DefaultCommentService.this.eventPublisher.publish((Object)new CommitDiscussionCommentEditedEvent((Object)this, (CommitDiscussion)internalCommentable, (Comment)comment, (Comment)comment.getParent(), previousText, previousSeverity, previousState));
                return null;
            }

            public Void visit(@Nonnull PullRequest pullRequest) {
                InternalPullRequest internalCommentable = InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
                DefaultCommentService.this.addActivity(internalCommentable, comment, CommentAction.EDITED);
                DefaultCommentService.this.eventPublisher.publish((Object)new PullRequestCommentEditedEvent((Object)this, (PullRequest)internalCommentable, (Comment)comment, (Comment)comment.getParent(), previousText, previousSeverity, previousState));
                return null;
            }
        });
    }

    private void publishAndThrowIfCanceled(CancelableEvent event, SimpleCancelState cancelState, String errorKey) {
        this.eventPublisher.publish((Object)event);
        if (cancelState.isCanceled()) {
            throw new RequestCanceledException(this.i18nService.createKeyedMessage(errorKey, new Object[0]), cancelState.getCancelMessages());
        }
    }

    private void requestCommentAdd(final InternalComment comment) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        CancelableEvent event = (CancelableEvent)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<CancelableEvent>(){

            public CancelableEvent visit(@Nonnull CommitDiscussion discussion) {
                return new CommitDiscussionCommentAddRequestedEvent((Object)this, discussion, (Comment)comment, (CancelState)cancelState);
            }

            public CancelableEvent visit(@Nonnull PullRequest pullRequest) {
                return new PullRequestCommentAddRequestedEvent((Object)this, pullRequest, (Comment)comment, (CancelState)cancelState);
            }
        });
        this.publishAndThrowIfCanceled(event, cancelState, "bitbucket.service.comment.new.canceled");
    }

    private void requestCommentDelete(final InternalComment comment) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        CancelableEvent event = (CancelableEvent)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<CancelableEvent>(){

            public CancelableEvent visit(@Nonnull CommitDiscussion discussion) {
                return new CommitDiscussionCommentDeletionRequestedEvent((Object)this, discussion, (Comment)comment, (Comment)comment.getParent(), (CancelState)cancelState);
            }

            public CancelableEvent visit(@Nonnull PullRequest pullRequest) {
                return new PullRequestCommentDeletionRequestedEvent((Object)this, pullRequest, (Comment)comment, (Comment)comment.getParent(), (CancelState)cancelState);
            }
        });
        this.publishAndThrowIfCanceled(event, cancelState, "bitbucket.service.comment.delete.canceled");
    }

    private void requestCommentEdit(final InternalComment comment, final String previousText) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        CancelableEvent event = (CancelableEvent)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<CancelableEvent>(){

            public CancelableEvent visit(@Nonnull CommitDiscussion discussion) {
                return new CommitDiscussionCommentModificationRequestedEvent((Object)this, discussion, (Comment)comment, (Comment)comment.getParent(), previousText, (CancelState)cancelState);
            }

            public CancelableEvent visit(@Nonnull PullRequest pullRequest) {
                return new PullRequestCommentModificationRequestedEvent((Object)this, pullRequest, (Comment)comment, (Comment)comment.getParent(), previousText, (CancelState)cancelState);
            }
        });
        this.publishAndThrowIfCanceled(event, cancelState, "bitbucket.service.comment.update.canceled");
    }

    private void requestCommentReply(final InternalComment comment) {
        final SimpleCancelState cancelState = new SimpleCancelState();
        CancelableEvent event = (CancelableEvent)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<CancelableEvent>(){

            public CancelableEvent visit(@Nonnull CommitDiscussion discussion) {
                return new CommitDiscussionCommentReplyRequestedEvent((Object)this, discussion, (Comment)comment, (Comment)comment.getParent(), (CancelState)cancelState);
            }

            public CancelableEvent visit(@Nonnull PullRequest pullRequest) {
                return new PullRequestCommentReplyRequestedEvent((Object)this, pullRequest, (Comment)comment, (Comment)comment.getParent(), (CancelState)cancelState);
            }
        });
        this.publishAndThrowIfCanceled(event, cancelState, "bitbucket.service.comment.reply.canceled");
    }

    private void requireThreadNotResolved(InternalCommentThread thread, String action) {
        if (thread.isResolved()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.comment.thread.cannot." + action, new Object[0]));
        }
    }

    private Page<InternalCommentThread> searchPending(PageRequest pageRequest, CommentSearchRequest request) {
        Page threads = this.commentThreadDao.searchPending(InternalConverter.convertToInternalCommentable((Commentable)request.getCommentable()), this.authenticationContext.getCurrentUser().getId(), pageRequest);
        this.filterPendingReplies(request, threads.getValues());
        return threads;
    }

    private boolean shouldFireEvent(boolean isPending, CommentState previousState, CommentState requestState, CommentSeverity previousSeverity) {
        if (isPending) {
            return false;
        }
        if (previousState == CommentState.RESOLVED && requestState != CommentState.RESOLVED || previousState != CommentState.RESOLVED && requestState == CommentState.RESOLVED) {
            return previousSeverity == CommentSeverity.BLOCKER;
        }
        return true;
    }

    private void updateDateAndOrSeverity(CommentUpdateRequest request, boolean isTextChanged, boolean isSeverityChanged, InternalComment.Builder builder) {
        if (isTextChanged) {
            builder.updatedDate(new Date());
        }
        if (isSeverityChanged) {
            builder.severity(request.getSeverity());
        }
    }
}

