/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionRequest;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.event.commit.CommitDiscussionParticipantsUpdatedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.commit.CommitDiscussionDao;
import com.atlassian.stash.internal.commit.CommitDiscussionHelper;
import com.atlassian.stash.internal.commit.CommitDiscussionParticipantDao;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="commitDiscussionHelper")
public class DefaultCommitDiscussionHelper
implements CommitDiscussionHelper {
    private final AuthenticationContext authenticationContext;
    private final CommitDiscussionDao discussionDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final CommitDiscussionParticipantDao participantDao;
    private final ScmService scmService;
    private final UserService userService;
    private final WatcherService watcherService;

    @Autowired
    public DefaultCommitDiscussionHelper(AuthenticationContext authenticationContext, CommitDiscussionDao discussionDao, EventPublisher eventPublisher, I18nService i18nService, CommitDiscussionParticipantDao participantDao, ScmService scmService, UserService userService, WatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.discussionDao = discussionDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.participantDao = participantDao;
        this.scmService = scmService;
        this.userService = userService;
        this.watcherService = watcherService;
    }

    @Override
    @Transactional
    public InternalCommitDiscussion getDiscussion(@Nonnull CommitDiscussionRequest request) {
        Objects.requireNonNull(request, "request");
        return this.doGet(request);
    }

    @Override
    @Transactional
    public void makeCurrentUserParticipantAndWatcher(@Nonnull InternalCommitDiscussion discussion) {
        Objects.requireNonNull(discussion, "discussion");
        this.maybeAddParticipant(discussion);
    }

    private void addParticipant(InternalCommitDiscussion discussion, InternalApplicationUser user) {
        this.participantDao.create((Object)((InternalCommitDiscussionParticipant.Builder)new InternalCommitDiscussionParticipant.Builder(discussion).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
        this.watcherService.watch(((WatchRequest.Builder)new WatchRequest.Builder((Watchable)discussion).user((ApplicationUser)user)).build());
        this.eventPublisher.publish((Object)new CommitDiscussionParticipantsUpdatedEvent((Object)this, (CommitDiscussion)discussion, Collections.singleton(user), Collections.emptySet()));
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion) {
        this.maybeAddParticipant(discussion, InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser()));
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion, InternalApplicationUser user) {
        InternalCommitDiscussionParticipant participant = this.participantDao.findByDiscussionAndUser(discussion.getId(), user.getId());
        if (participant == null) {
            this.addParticipant(discussion, user);
        }
    }

    private InternalCommitDiscussion doGet(CommitDiscussionRequest request) {
        String commitId = request.getCommitId();
        Repository repository = request.getRepository();
        InternalCommitDiscussion discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId(), commitId);
        if (request.isCreate() && discussion == null) {
            Commit commit = (Commit)this.scmService.getCommandFactory(repository).commit(((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().commitId(commitId)).maxMessageLength(0).build()).call();
            if (commit == null) {
                throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{repository.getName(), commitId}), commitId);
            }
            discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId(), commit.getId());
            if (discussion == null) {
                try {
                    InternalApplicationUser author = this.findAuthor(commit);
                    discussion = this.createDiscussion(repository, commit, author);
                }
                catch (RuntimeException e) {
                    if (this.isDataIntegrityViolation(e) && (discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId(), commit.getId())) != null) {
                        return discussion;
                    }
                    throw e;
                }
            }
        }
        return discussion;
    }

    private InternalCommitDiscussion createDiscussion(Repository repository, Commit commit, InternalApplicationUser author) {
        InternalCommitDiscussion discussion = (InternalCommitDiscussion)this.discussionDao.create((Object)new InternalCommitDiscussion.Builder(InternalConverter.convertToInternalRepository((Repository)repository), commit.getId()).parents(commit.getParents()).build());
        if (author != null) {
            this.addParticipant(discussion, author);
        }
        return discussion;
    }

    private InternalApplicationUser findAuthor(Commit commit) {
        String emailAddress = commit.getAuthor().getEmailAddress();
        return StringUtils.isBlank((CharSequence)emailAddress) ? null : InternalConverter.convertToInternalUser((ApplicationUser)this.userService.findUserByEmail(emailAddress));
    }

    private boolean isDataIntegrityViolation(RuntimeException e) {
        return Throwables.getCausalChain((Throwable)e).stream().anyMatch(DataIntegrityViolationException.class::isInstance);
    }
}

