/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.commit.AbstractCommitsRequest;
import com.atlassian.bitbucket.commit.BatchingCommitCallback;
import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.ChangesetsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionRequest;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.CommitsRequest;
import com.atlassian.bitbucket.commit.CommonAncestorRequest;
import com.atlassian.bitbucket.commit.LastModifiedCallback;
import com.atlassian.bitbucket.commit.LastModifiedContext;
import com.atlassian.bitbucket.commit.LastModifiedRequest;
import com.atlassian.bitbucket.commit.LastModifiedSummary;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.commit.PagedBatchingCommitCallback;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.commit.graph.TraversalRequest;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.DiffStatsSummaryRequest;
import com.atlassian.bitbucket.dmz.commit.DmzCommitEnricher;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesetsCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.CommonAncestorCommandParameters;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.DiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.LastModifiedCommandParameters;
import com.atlassian.bitbucket.scm.bulk.BulkCommitCallback;
import com.atlassian.bitbucket.scm.bulk.BulkCommitsCommandParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedCallback;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.comment.CommentCountChangeCallback;
import com.atlassian.stash.internal.comment.CommentCountChangeTransform;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.InternalCommentService;
import com.atlassian.stash.internal.commit.CommitDiscussionHelper;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitService;
import com.atlassian.stash.internal.commit.graph.CommitGraphSource;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=CommitService.class)
@Service(value="commitService")
public class DefaultCommitService
extends AbstractScmService
implements InternalCommitService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommitService.class);
    private final InternalCommentService commentService;
    private final CommitDiscussionHelper discussionHelper;
    private final DmzCommitEnricher enricher;
    private final CommitGraphSource graphSource;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    @Value(value="${commit.lastmodified.timeout}")
    private long lastModifiedTimeout;
    @Value(value="${commit.message.max}")
    private int maxMessageLength;

    @Autowired
    public DefaultCommitService(InternalScmService scmService, InternalCommentService commentService, CommitDiscussionHelper discussionHelper, DmzCommitEnricher enricher, CommitGraphSource graphSource, I18nService i18nService, PermissionService permissionService) {
        super(scmService);
        this.commentService = commentService;
        this.discussionHelper = discussionHelper;
        this.enricher = enricher;
        this.graphSource = graphSource;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Optional<Commit> findCommit(@Nonnull CommitRequest request) {
        Objects.requireNonNull(request, "request");
        try {
            return Optional.of(this.getCommit(request));
        }
        catch (NoSuchCommitException e) {
            return Optional.empty();
        }
    }

    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public InternalCommitDiscussion findDiscussionById(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.getDiscussion(repository, commitId);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Page<Change> getChanges(@Nonnull ChangesRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChanges);
        ChangesCommandParameters parameters = ((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder(request).maxChanges(this.maxChanges)).build();
        Page page = (Page)this.getCommandFactory(request.getRepository()).changes(parameters, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        } else {
            Map<InternalChangeLocation, CommentCounts> countsByLocation = this.getCountsByLocation(request);
            if (!countsByLocation.isEmpty()) {
                page = page.transform((Function)new CommentCountChangeTransform(countsByLocation));
            }
        }
        return page;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Page<Changeset> getChangesets(@Nonnull ChangesetsRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Page page = (Page)this.getCommandFactory(request.getRepository()).changesets(new ChangesetsCommandParameters.Builder().commitIds(request.getCommitIds()).maxChangesPerCommit(Math.min(request.getMaxChangesPerCommit(), this.maxChanges)).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).ignoreMissing(request.isIgnoreMissing()).build(), pageRequest).call();
        if (page == null) {
            page = PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return page;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Commit getCommit(@Nonnull CommitRequest request) {
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        String commitId = request.getCommitId();
        Commit commit = (Commit)this.getCommandFactory(repository).commit(new CommitCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build()).call();
        if (commit == null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{repository.getName(), commitId}), commitId);
        }
        return this.enricher.enrich(repository, commit, (Collection)request.getPropertyKeys());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public Page<Commit> getCommits(@Nonnull CommitsRequest request, @Nonnull PageRequest pageRequest) {
        return this.getCommits(new CommitsCommandParameters.Builder(request), (AbstractCommitsRequest)request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository) and isRepositoryAccessible(#request?.secondaryRepository)")
    public Page<Commit> getCommitsBetween(@Nonnull CommitsBetweenRequest request, @Nonnull PageRequest pageRequest) {
        return this.getCommits(new CommitsCommandParameters.Builder(request), (AbstractCommitsRequest)request, pageRequest);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository) and isRepositoryAccessible(#request?.secondaryRepository)")
    public Optional<MinimalCommit> getCommonAncestor(@Nonnull CommonAncestorRequest request) {
        CommonAncestorCommandParameters parameters = new CommonAncestorCommandParameters.Builder().commitId((Iterable)Objects.requireNonNull(request, "request").getCommitIds()).secondaryRepository(request.getSecondaryRepository()).build();
        return Optional.ofNullable((MinimalCommit)this.scmService.getCommandFactory(request.getRepository()).commonAncestor(parameters).call());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public DiffStatsSummary getDiffStatsSummary(@Nonnull DiffStatsSummaryRequest request) {
        Objects.requireNonNull(request, "request");
        ImmutableSet.Builder pathsBuilder = ImmutableSet.builder();
        pathsBuilder.addAll((Iterable)request.getPaths());
        if (request.isWithAutoSrcPath()) {
            this.resolveSrcPath(request).ifPresent(arg_0 -> ((ImmutableSet.Builder)pathsBuilder).add(arg_0));
        }
        ImmutableSet paths = pathsBuilder.build();
        Repository repository = request.getRepository();
        return (DiffStatsSummary)this.getCommandFactory(repository).diffStatsSummary(((DiffStatsSummaryCommandParameters.Builder)((DiffStatsSummaryCommandParameters.Builder)new DiffStatsSummaryCommandParameters.Builder().paths((Iterable)paths)).secondaryRepository(request.getSecondaryRepository()).sinceId(request.getSinceId()).untilId(request.getUntilId()).whitespace(request.getWhitespace())).build()).call();
    }

    @Nullable
    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public CommitDiscussion getDiscussion(@Nonnull CommitDiscussionRequest request) {
        Objects.requireNonNull(request, "request");
        return this.discussionHelper.getDiscussion(request);
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamChanges(@Nonnull ChangesRequest request, @Nonnull ChangeCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        Map<InternalChangeLocation, CommentCounts> countsByLocation = this.getCountsByLocation(request);
        if (!countsByLocation.isEmpty()) {
            callback = new CommentCountChangeCallback(callback, countsByLocation);
        }
        this.getCommandFactory(request.getRepository()).changes(((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder(request).maxChanges(this.maxChanges)).build(), callback).call();
    }

    @Secured(value="Secured internally with a repository accessible predicate")
    public void streamCommits(@Nonnull BulkCommitsRequest request, @Nonnull BulkCommitCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        Map commitsByRepository = request.getCommits();
        if (commitsByRepository.isEmpty()) {
            return;
        }
        Set repositories = commitsByRepository.keySet();
        repositories.forEach(repository -> {
            if (!this.permissionService.isRepositoryAccessible(repository)) {
                throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.accessdenied", new Object[0]));
            }
        });
        this.scmService.getBulkContentCommandFactory((Repository)Iterables.getFirst(repositories, null)).commits(new BulkCommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength().orElse(-1))).build(), callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamCommits(@Nonnull CommitsRequest request, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), this.enrichingCallback(callback, request.getRepository(), request.getPropertyKeys())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository) and isRepositoryAccessible(#request?.secondaryRepository)")
    public void streamCommitsBetween(@Nonnull CommitsBetweenRequest request, @Nonnull CommitCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), this.enrichingCallback(callback, request.getRepository(), request.getPropertyKeys())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamDiff(@Nonnull DiffRequest request, @Nonnull DiffContentCallback callback) {
        InternalCommitDiscussion discussion;
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        ImmutableSet.Builder pathsBuilder = ImmutableSet.builder();
        pathsBuilder.addAll((Iterable)request.getPaths());
        if (request.isWithAutoSrcPath()) {
            this.resolveSrcPath(request).ifPresent(arg_0 -> ((ImmutableSet.Builder)pathsBuilder).add(arg_0));
        }
        ImmutableSet paths = pathsBuilder.build();
        if (this.includeComments(request) && (discussion = this.getDiscussion(request.getRepository(), request.getUntilId())) != null) {
            try {
                List threads = this.commentService.searchThreads(new CommentSearchRequest.Builder((Commentable)discussion).fromHash(request.getSinceId()).path((String)Iterables.getFirst((Iterable)paths, null)).toHash(discussion.getCommitId()).build());
                callback.offerThreads(threads.stream().map(CommentThread.class::cast));
            }
            catch (IOException e) {
                log.warn("{}: Failed to offer anchors to DiffContentCallback", (Object)request.getRepository(), (Object)e);
            }
        }
        Repository repository = request.getRepository();
        this.getCommandFactory(repository).diff(((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths((Iterable)paths)).sinceId(request.getSinceId()).untilId(request.getUntilId()).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamDiff(@Nonnull DiffRequest request, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(outputSupplier, "outputSupplier");
        ImmutableSet.Builder pathsBuilder = ImmutableSet.builder();
        pathsBuilder.addAll((Iterable)request.getPaths());
        if (request.isWithAutoSrcPath()) {
            this.resolveSrcPath(request).ifPresent(arg_0 -> ((ImmutableSet.Builder)pathsBuilder).add(arg_0));
        }
        ImmutableSet paths = pathsBuilder.build();
        Repository repository = request.getRepository();
        this.getCommandFactory(repository).diff(((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).paths((Iterable)paths)).secondaryRepository(request.getSecondaryRepository())).sinceId(request.getSinceId()).untilId(request.getUntilId()).whitespace(request.getWhitespace())).build(), outputSupplier).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void streamLastModified(@Nonnull LastModifiedRequest request, @Nonnull LastModifiedCallback callback) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(callback, "callback");
        Command command = this.scmService.getExtendedCommandFactory(request.getRepository()).lastModified(new LastModifiedCommandParameters.Builder(request).maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), this.enrichingCallback(callback, request.getRepository()));
        command.setTimeout(this.lastModifiedTimeout);
        command.call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request?.repository)")
    public void traverse(@Nonnull TraversalRequest request, @Nonnull TraversalCallback callback) {
        this.graphSource.traverse(request, callback);
    }

    private CommitCallback enrichingCallback(CommitCallback callback, final Repository repository, final Collection<String> propertyKeys) {
        if (callback instanceof PagedCallback) {
            return new PagedBatchingCommitCallback(callback, 25){

                protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
                    return super.onCommits(DefaultCommitService.this.enricher.enrichAll(repository, commits, propertyKeys));
                }
            };
        }
        return new BatchingCommitCallback(callback, 25){

            protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
                return super.onCommits(DefaultCommitService.this.enricher.enrichAll(repository, commits, propertyKeys));
            }
        };
    }

    private LastModifiedCallback enrichingCallback(final LastModifiedCallback callback, final Repository repository) {
        return new LastModifiedCallback(){
            private final Map<String, Commit> batch = new LinkedHashMap<String, Commit>(25, 1.0f);

            public void onEnd(@Nonnull LastModifiedSummary summary) throws IOException {
                if (!this.batch.isEmpty()) {
                    this.flush();
                }
                callback.onEnd(summary.getLatestCommit().map(commit -> DefaultCommitService.this.enricher.enrich(repository, commit, null)).map(commit -> new LastModifiedSummary.Builder(summary.getResult()).latestCommit(commit).build()).orElse(summary));
            }

            public boolean onFile(@Nonnull String file, @Nonnull Commit commit) throws IOException {
                this.batch.put(file, commit);
                return this.batch.size() < 25 || this.flush();
            }

            public void onStart(@Nonnull LastModifiedContext context) throws IOException {
                callback.onStart(context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean flush() throws IOException {
                try {
                    Iterable enrichedCommits = DefaultCommitService.this.enricher.enrichAll(repository, this.batch.values(), null);
                    Iterator<String> fileIterator = this.batch.keySet().iterator();
                    Iterator commitIterator = enrichedCommits.iterator();
                    while (fileIterator.hasNext() && commitIterator.hasNext()) {
                        if (callback.onFile(fileIterator.next(), (Commit)commitIterator.next())) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    this.batch.clear();
                }
                return true;
            }
        };
    }

    private Page<Commit> getCommits(@Nonnull CommitsCommandParameters.Builder builder, @Nonnull AbstractCommitsRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Repository repository = request.getRepository();
        Page commits = (Page)this.getCommandFactory(repository).commits(builder.maxMessageLength(this.restrictMessageLength(request.getMaxMessageLength())).build(), pageRequest).call();
        if (commits == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.enricher.enrichPage(repository, commits, (Collection)request.getPropertyKeys());
    }

    private Map<InternalChangeLocation, CommentCounts> getCountsByLocation(ChangesRequest request) {
        InternalCommitDiscussion discussion;
        if (this.includeCounts(request) && (discussion = this.getDiscussion(request.getRepository(), request.getUntilId())) != null) {
            String fromHash = request.getSinceId() == null ? discussion.getParentId() : request.getSinceId();
            return this.commentService.countCommentsByLocation(new CommentSearchRequest.Builder((Commentable)discussion).fromHash(fromHash).toHash(discussion.getCommitId()).build());
        }
        return Collections.emptyMap();
    }

    private InternalCommitDiscussion getDiscussion(@Nonnull Repository repository, @Nonnull String commitId) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitId, "commitId");
        return this.discussionHelper.getDiscussion(new CommitDiscussionRequest.Builder(repository, commitId).build());
    }

    private boolean includeComments(DiffRequest request) {
        return request.isWithComments() && this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_READ);
    }

    private boolean includeCounts(ChangesRequest request) {
        return request.isWithComments() && this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_READ);
    }

    private Optional<String> resolveSrcPath(DiffStatsSummaryRequest diffStatsSummaryRequest) {
        return this.resolveSrcPath(diffStatsSummaryRequest.getRepository(), diffStatsSummaryRequest.getSinceId(), diffStatsSummaryRequest.getUntilId(), diffStatsSummaryRequest.getPaths());
    }

    private Optional<String> resolveSrcPath(DiffRequest diffRequest) {
        return this.resolveSrcPath(diffRequest.getRepository(), diffRequest.getSinceId(), diffRequest.getUntilId(), diffRequest.getPaths());
    }

    private Optional<String> resolveSrcPath(Repository repository, String sinceId, String untilId, Set<String> paths) {
        CommitsBetweenRequest srcPathRequest = ((CommitsBetweenRequest.Builder)((CommitsBetweenRequest.Builder)new CommitsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).followRenames(true)).include(untilId, new String[0]).path((String)Iterables.getOnlyElement(paths))).build();
        return this.getCommitsBetween(srcPathRequest, PageUtils.newRequest((int)0, (int)1)).stream().findFirst().map(PropertySupport::getProperties).map(properties -> {
            Map changeMap;
            Object change = properties.get((Object)"change");
            if (change instanceof Map && (changeMap = (Map)change).get("type") == ChangeType.MOVE) {
                return (String)changeMap.get("srcPath");
            }
            return null;
        });
    }

    private int restrictMessageLength(int length) {
        if (length < 0 || length > this.maxMessageLength) {
            return this.maxMessageLength;
        }
        return length;
    }
}

